/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Consumer;

public class Encoder
implements Consumer<int[]> {
    private Charset charset;
    private final Consumer<byte[]> out;

    public Encoder(Charset charset, Consumer<byte[]> out) {
        this.charset = charset != null ? charset : Charset.defaultCharset();
        this.out = out;
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    @Override
    public void accept(int[] input) {
        ByteBuffer bytesBuf = this.charset.encode(Encoder.toCharBuffer(input));
        this.out.accept(Encoder.safeTrim(bytesBuf.array(), bytesBuf.limit()));
    }

    public static CharBuffer toCharBuffer(int[] input) {
        char[] tmp = new char[2];
        int capacity = 0;
        for (int codePoint : input) {
            capacity += Character.charCount(codePoint);
        }
        CharBuffer charBuf = CharBuffer.allocate(capacity);
        for (int in : input) {
            int size = Character.toChars(in, tmp, 0);
            charBuf.put(tmp, 0, size);
        }
        charBuf.flip();
        return charBuf;
    }

    private static byte[] safeTrim(byte[] bytes, int length) {
        if (bytes.length == length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, length);
    }
}

