/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security;

import java.io.IOException;
import org.aesh.command.impl.internal.ParsedCommand;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.ConnectedActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.AbstractControlledCommand;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.dmr.ModelNode;

public class ControlledCommandActivator
extends ConnectedActivator {
    @Override
    public boolean isActivated(ParsedCommand cmd) {
        boolean available;
        if (!super.isActivated(cmd)) {
            return false;
        }
        AbstractControlledCommand controlled = (AbstractControlledCommand)cmd.command();
        CommandContext ctx = this.getCommandContext();
        if (controlled.isDependsOnProfile() && ctx.isDomainMode()) {
            return ctx.getConfig().isAccessControl() ? controlled.getAccessRequirement().isSatisfied(ctx) : true;
        }
        if (controlled.getRequiredType() == null) {
            available = this.isAddressValid(ctx, controlled.getRequiredAddress());
        } else {
            ModelNode result;
            ModelNode request = new ModelNode();
            ModelNode address = request.get("address");
            for (OperationRequestAddress.Node node : controlled.getRequiredAddress()) {
                address.add(node.getType(), node.getName());
            }
            request.get("operation").set("read-children-types");
            try {
                result = ctx.getModelControllerClient().execute(request);
            }
            catch (IOException e) {
                return false;
            }
            available = Util.listContains(result, controlled.getRequiredType());
        }
        if (ctx.getConfig().isAccessControl()) {
            available = available && controlled.getAccessRequirement().isSatisfied(ctx);
        }
        return available;
    }

    protected boolean isAddressValid(CommandContext ctx, OperationRequestAddress requiredAddress) {
        ModelNode response;
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        address.setEmptyList();
        request.get("operation").set("validate-address");
        ModelNode addressValue = request.get("value");
        for (OperationRequestAddress.Node node : requiredAddress) {
            addressValue.add(node.getType(), node.getName());
        }
        try {
            response = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return false;
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            return false;
        }
        ModelNode valid = result.get("valid");
        if (!valid.isDefined()) {
            return false;
        }
        return valid.asBoolean();
    }
}

