/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.protocol.mgmt.support.ManagementChannelShutdownHandle;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRequestTracker;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HttpShutdownService
implements Service<Void> {
    private static final long SHUTDOWN_TIMEOUT = 15L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private final InjectedValue<Executor> executorValue = new InjectedValue();
    private final InjectedValue<ManagementHttpRequestProcessor> processorValue = new InjectedValue();
    private final InjectedValue<ManagementChannelRegistryService> mgmtChannelRegistry = new InjectedValue();
    private volatile ManagementRequestTracker trackerService;

    public synchronized void start(StartContext context) throws StartException {
        final ManagementHttpRequestProcessor processor = (ManagementHttpRequestProcessor)this.processorValue.getValue();
        this.trackerService = ((ManagementChannelRegistryService)this.mgmtChannelRegistry.getValue()).getTrackerService();
        this.trackerService.registerTracker((ManagementChannelShutdownHandle)processor);
        processor.addShutdownListener(new ManagementHttpRequestProcessor.ShutdownListener(){

            public void handleCompleted() {
                HttpShutdownService.this.trackerService.unregisterTracker((ManagementChannelShutdownHandle)processor);
            }
        });
    }

    public synchronized void stop(final StopContext context) {
        this.trackerService.prepareShutdown();
        context.asynchronous();
        try {
            ((Executor)this.executorValue.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpShutdownService.this.trackerService.awaitShutdown(15L, TIME_UNIT);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        context.complete();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            context.complete();
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public InjectedValue<Executor> getExecutorValue() {
        return this.executorValue;
    }

    public InjectedValue<ManagementHttpRequestProcessor> getProcessorValue() {
        return this.processorValue;
    }

    public InjectedValue<ManagementChannelRegistryService> getMgmtChannelRegistry() {
        return this.mgmtChannelRegistry;
    }
}

