/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public class MIMECacheEntry
implements Serializable {
    private static final long serialVersionUID = -7857224258673285445L;
    public String contentType;
    public byte[] data;

    public MIMECacheEntry() {
    }

    public MIMECacheEntry(String contentType, byte[] data) {
        this.contentType = contentType;
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MIMECacheEntry)) {
            return false;
        }
        MIMECacheEntry that = (MIMECacheEntry)o;
        return !(this.contentType == null ? that.contentType != null : !this.contentType.equals(that.contentType)) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return 31 * (this.contentType != null ? this.contentType.hashCode() : 0) + (this.data != null ? Arrays.hashCode(this.data) : 0);
    }

    public static class Externalizer
    extends AbstractExternalizer<MIMECacheEntry> {
        public Set<Class<? extends MIMECacheEntry>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MIMECacheEntry.class});
        }

        public void writeObject(ObjectOutput out, MIMECacheEntry obj) throws IOException {
            out.writeUTF(obj.contentType);
            out.writeInt(obj.data.length);
            out.write(obj.data);
        }

        public MIMECacheEntry readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            String contentType = in.readUTF();
            int len = in.readInt();
            byte[] data = new byte[len];
            in.readFully(data);
            return new MIMECacheEntry(contentType, data);
        }

        public Integer getId() {
            return 100;
        }
    }
}

