/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.tx;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jberet._private.BatchLogger;

public class LocalTransactionManager
implements TransactionManager {
    private final ThreadLocal<Integer> status = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 6;
        }
    };

    private LocalTransactionManager() {
    }

    public static LocalTransactionManager getInstance() {
        return Holder.INSTANCE;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.status.set(0);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.status.set(3);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.status.set(4);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status.set(1);
    }

    public int getStatus() throws SystemException {
        return this.status.get();
    }

    public Transaction getTransaction() throws SystemException {
        return null;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        BatchLogger.LOGGER.notImplementedOnLocalTx("setTransactionTimeout");
    }

    public Transaction suspend() throws SystemException {
        BatchLogger.LOGGER.notImplementedOnLocalTx("resume");
        return null;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        BatchLogger.LOGGER.notImplementedOnLocalTx("resume");
    }

    private static class Holder {
        static final LocalTransactionManager INSTANCE = new LocalTransactionManager();

        private Holder() {
        }
    }
}

