/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.picketlink.idm.jdbc.internal.model.PartitionJdbcType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public abstract class AbstractStorageUtil {
    protected Object[] getValuesFromParamMap(Map<QueryParameter, Object[]> params, AttributeParameter attributeParameter) {
        Set<QueryParameter> keys = params.keySet();
        if (keys != null) {
            for (QueryParameter key : keys) {
                AttributeParameter aparam;
                if (!(key instanceof AttributeParameter) || !(aparam = (AttributeParameter)key).getName().equalsIgnoreCase(attributeParameter.getName())) continue;
                return params.get(key);
            }
        }
        return null;
    }

    protected Partition loadPartition(DataSource dataSource, String id) {
        if (dataSource == null) {
            throw new RuntimeException("Null datasource");
        }
        if (id == null) {
            throw new RuntimeException("Null id");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select name from Partition where id =?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, id);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                PartitionJdbcType partition;
                PartitionJdbcType partitionJdbcType = partition = new PartitionJdbcType(resultSet.getString(1));
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                return partitionJdbcType;
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        return null;
    }

    protected void safeClose(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

