/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;

class SessionInvocationContext
implements InvocationContext {
    private boolean isLocked;
    private Object key;
    private CacheEntry cacheEntry;
    private final Object lockOwner;
    private final Object session;

    public SessionInvocationContext(Object session, Object lockOwner) {
        this.session = session;
        this.lockOwner = lockOwner;
    }

    public boolean isOriginLocal() {
        return true;
    }

    public boolean isInTxScope() {
        return false;
    }

    public Object getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(Object lockOwner) {
        throw new UnsupportedOperationException();
    }

    public InvocationContext clone() {
        try {
            return (InvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!", e);
        }
    }

    public Set<Object> getLockedKeys() {
        return this.isLocked ? Collections.singleton(this.key) : Collections.emptySet();
    }

    public void clearLockedKeys() {
        this.isLocked = false;
    }

    public void addLockedKey(Object key) {
        if (this.key == null) {
            this.key = key;
        } else if (!this.isKeyEquals(key)) {
            throw this.illegalStateException();
        }
        this.isLocked = true;
    }

    private IllegalStateException illegalStateException() {
        return new IllegalStateException("This is a single key invocation context, using multiple keys shouldn't be possible");
    }

    public CacheEntry lookupEntry(Object key) {
        if (this.key != null && this.isKeyEquals(key)) {
            return this.cacheEntry;
        }
        return null;
    }

    public boolean isKeyEquals(Object key) {
        return this.key == key || this.key.equals(key);
    }

    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.cacheEntry == null ? Collections.emptyMap() : Collections.singletonMap(this.key, this.cacheEntry);
    }

    public void forEachEntry(BiConsumer<Object, CacheEntry> action) {
        if (this.cacheEntry != null) {
            action.accept(this.key, this.cacheEntry);
        }
    }

    public int lookedUpEntriesCount() {
        return this.cacheEntry != null ? 1 : 0;
    }

    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.key == null) {
            this.key = key;
        } else if (!this.isKeyEquals(key)) {
            throw this.illegalStateException();
        }
        this.cacheEntry = e;
    }

    public void removeLookedUpEntry(Object key) {
        if (this.key != null && this.isKeyEquals(key)) {
            this.cacheEntry = null;
        }
    }

    public Object getKey() {
        return this.key;
    }

    public Address getOrigin() {
        return LocalModeAddress.INSTANCE;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
    }

    public boolean hasLockedKey(Object key) {
        return this.isLocked && this.isKeyEquals(key);
    }

    public boolean isEntryRemovedInContext(Object key) {
        CacheEntry ce = this.lookupEntry(key);
        return ce != null && ce.isRemoved() && ce.isChanged();
    }

    public Object getSession() {
        return this.session;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleKeyNonTxInvocationContext{");
        sb.append("isLocked=").append(this.isLocked);
        sb.append(", key=").append(this.key);
        sb.append(", cacheEntry=").append(this.cacheEntry);
        sb.append(", lockOwner=").append(this.lockOwner);
        sb.append(", session=").append(this.session);
        sb.append('}');
        return sb.toString();
    }
}

