/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Supplier;

public class AgroalConnectionFactoryConfigurationSupplier
implements Supplier<AgroalConnectionFactoryConfiguration> {
    private static final String USER_PROPERTY_NAME = "user";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private volatile boolean lock = false;
    private boolean autoCommit = true;
    private String jdbcUrl = "";
    private String initialSql = "";
    private Class<?> connectionProviderClass;
    private AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolation = AgroalConnectionFactoryConfiguration.TransactionIsolation.UNDEFINED;
    private Principal principal;
    private Collection<Object> credentials = new ArrayList<Object>();
    private Properties jdbcProperties = new Properties();

    public AgroalConnectionFactoryConfigurationSupplier() {
    }

    public AgroalConnectionFactoryConfigurationSupplier(AgroalConnectionFactoryConfiguration existingConfiguration) {
        this();
        if (existingConfiguration == null) {
            return;
        }
        this.autoCommit = existingConfiguration.autoCommit();
        this.jdbcUrl = existingConfiguration.jdbcUrl();
        this.initialSql = existingConfiguration.initialSql();
        this.connectionProviderClass = existingConfiguration.connectionProviderClass();
        this.transactionIsolation = existingConfiguration.jdbcTransactionIsolation();
        this.principal = existingConfiguration.principal();
        this.credentials = existingConfiguration.credentials();
        this.jdbcProperties = existingConfiguration.jdbcProperties();
    }

    private void checkLock() {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
    }

    public AgroalConnectionFactoryConfigurationSupplier autoCommit(boolean autoCommitEnabled) {
        this.checkLock();
        this.autoCommit = autoCommitEnabled;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcUrl(String jdbcUrlString) {
        this.checkLock();
        this.jdbcUrl = jdbcUrlString;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier initialSql(String initialSqlString) {
        this.checkLock();
        this.initialSql = initialSqlString;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier connectionProviderClass(Class<?> connectionProvider) {
        this.checkLock();
        this.connectionProviderClass = connectionProvider;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier connectionProviderClassName(String connectionProviderName) {
        try {
            this.checkLock();
            this.connectionProviderClass = connectionProviderName == null ? null : Class.forName(connectionProviderName);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + connectionProviderName, e);
        }
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolationLevel) {
        this.checkLock();
        this.transactionIsolation = transactionIsolationLevel;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier principal(Principal loginPrincipal) {
        this.checkLock();
        this.principal = loginPrincipal;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier credential(Object credential) {
        this.checkLock();
        this.credentials.add(credential);
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcProperty(String key, String value) {
        this.checkLock();
        this.jdbcProperties.put(key, value);
        return this;
    }

    private void validate() {
        if (this.jdbcProperties.containsKey(USER_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Invalid JDBC property 'user': use principal instead.");
        }
        if (this.jdbcProperties.containsKey(PASSWORD_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Invalid property 'password': use credential instead.");
        }
    }

    @Override
    public AgroalConnectionFactoryConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalConnectionFactoryConfiguration(){

            @Override
            public boolean autoCommit() {
                return AgroalConnectionFactoryConfigurationSupplier.this.autoCommit;
            }

            @Override
            public String jdbcUrl() {
                return AgroalConnectionFactoryConfigurationSupplier.this.jdbcUrl;
            }

            @Override
            public String initialSql() {
                return AgroalConnectionFactoryConfigurationSupplier.this.initialSql;
            }

            @Override
            public Class<?> connectionProviderClass() {
                return AgroalConnectionFactoryConfigurationSupplier.this.connectionProviderClass;
            }

            @Override
            public AgroalConnectionFactoryConfiguration.TransactionIsolation jdbcTransactionIsolation() {
                return AgroalConnectionFactoryConfigurationSupplier.this.transactionIsolation;
            }

            @Override
            public Principal principal() {
                return AgroalConnectionFactoryConfigurationSupplier.this.principal;
            }

            @Override
            public Collection<Object> credentials() {
                return AgroalConnectionFactoryConfigurationSupplier.this.credentials;
            }

            @Override
            public Properties jdbcProperties() {
                return AgroalConnectionFactoryConfigurationSupplier.this.jdbcProperties;
            }
        };
    }
}

