/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LegacyPropertyAddOperationTransformer
implements OperationTransformer {
    private final Function<ModelNode, PathAddress> addressResolver;

    public LegacyPropertyAddOperationTransformer() {
        this(operation -> Operations.getPathAddress(operation));
    }

    public LegacyPropertyAddOperationTransformer(Function<ModelNode, PathAddress> addressResolver) {
        this.addressResolver = addressResolver;
    }

    @Override
    public ModelNode transformOperation(ModelNode operation) {
        if (operation.hasDefined("properties")) {
            ModelNode addOperation = operation.clone();
            List properties = addOperation.remove("properties").asPropertyList();
            ArrayList<ModelNode> operations = new ArrayList<ModelNode>(properties.size() + 1);
            operations.add(addOperation);
            PathAddress address = this.addressResolver.apply(addOperation);
            for (Property property : properties) {
                String key = property.getName();
                ModelNode value = property.getValue();
                ModelNode propertyAddOperation = Util.createAddOperation((PathAddress)address.append(new PathElement[]{PathElement.pathElement((String)"property", (String)key)}));
                propertyAddOperation.get("value").set(value);
                operations.add(propertyAddOperation);
            }
            return Operations.createCompositeOperation(operations);
        }
        return operation;
    }
}

