/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.dmr;

import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModelNodes {
    public static float asFloat(ModelNode value) {
        return Double.valueOf(value.asDouble()).floatValue();
    }

    public static <E extends Enum<E>> E asEnum(ModelNode value, Class<E> targetClass) {
        return Enum.valueOf(targetClass, value.asString());
    }

    public static Optional<Boolean> optionalBoolean(ModelNode value) {
        return value.isDefined() ? Optional.of(value.asBoolean()) : Optional.empty();
    }

    public static OptionalDouble optionalDouble(ModelNode value) {
        return value.isDefined() ? OptionalDouble.of(value.asDouble()) : OptionalDouble.empty();
    }

    public static Optional<Float> optionalFloat(ModelNode value) {
        return value.isDefined() ? Optional.of(Float.valueOf(ModelNodes.asFloat(value))) : Optional.empty();
    }

    public static OptionalInt optionalInt(ModelNode value) {
        return value.isDefined() ? OptionalInt.of(value.asInt()) : OptionalInt.empty();
    }

    public static OptionalLong optionalLong(ModelNode value) {
        return value.isDefined() ? OptionalLong.of(value.asInt()) : OptionalLong.empty();
    }

    public static Optional<String> optionalString(ModelNode value) {
        return value.isDefined() ? Optional.of(value.asString()) : Optional.empty();
    }

    public static Optional<Property> optionalProperty(ModelNode value) {
        return value.isDefined() ? Optional.of(value.asProperty()) : Optional.empty();
    }

    public static Optional<List<Property>> optionalPropertyList(ModelNode value) {
        return value.isDefined() ? Optional.of(value.asPropertyList()) : Optional.empty();
    }

    public static Optional<List<ModelNode>> optionalList(ModelNode value) {
        return value.isDefined() ? Optional.of(value.asList()) : Optional.empty();
    }

    public static <E extends Enum<E>> Optional<E> optionalEnum(ModelNode value, Class<E> targetClass) {
        return value.isDefined() ? Optional.of(ModelNodes.asEnum(value, targetClass)) : Optional.empty();
    }

    private ModelNodes() {
    }
}

