/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebServerService;
import org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecServiceConfiguratorProvider;

class ServerAdd
extends AbstractAddStepHandler {
    ServerAdd() {
        super(new AbstractAddStepHandler.Parameters().addAttribute(ServerDefinition.ATTRIBUTES).addRuntimeCapability(new RuntimeCapability[]{ServerDefinition.SERVER_CAPABILITY}));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode parentModel = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false).getModel();
        String name = context.getCurrentAddressValue();
        String defaultHost = ServerDefinition.DEFAULT_HOST.resolveModelAttribute(context, resource.getModel()).asString();
        String servletContainer = ServerDefinition.SERVLET_CONTAINER.resolveModelAttribute(context, resource.getModel()).asString();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, parentModel).asString();
        Server service = new Server(name, defaultHost);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(ServerDefinition.SERVER_CAPABILITY, (Service)service).addCapabilityRequirement("org.wildfly.undertow.servlet-container", ServletContainerService.class, service.getServletContainerInjector(), new String[]{servletContainer}).addCapabilityRequirement("org.wildfly.undertow", UndertowService.class, service.getUndertowServiceInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        boolean isDefaultServer = name.equals(defaultServerName);
        if (isDefaultServer) {
            builder.addAliases(new ServiceName[]{UndertowService.DEFAULT_SERVER});
            WebServerService commonWebServer = new WebServerService();
            CapabilityServiceBuilder commonServerBuilder = context.getCapabilityServiceTarget().addCapability(CommonWebServer.CAPABILITY, (Service)commonWebServer).addCapabilityRequirement("org.wildfly.undertow.server", Server.class, commonWebServer.getServerInjectedValue(), new String[]{name}).setInitialMode(ServiceController.Mode.PASSIVE);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<WebServerService>)commonServerBuilder, UndertowExtension.HTTP_LISTENER_PATH);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<WebServerService>)commonServerBuilder, UndertowExtension.AJP_LISTENER_PATH);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<WebServerService>)commonServerBuilder, UndertowExtension.HTTPS_LISTENER_PATH);
            commonServerBuilder.addAliases(new ServiceName[]{CommonWebServer.SERVICE_NAME});
            commonServerBuilder.install();
        }
        builder.install();
        ServiceTarget target = context.getServiceTarget();
        DistributableSessionIdentifierCodecServiceConfiguratorProvider provider = DistributableSessionIdentifierCodecServiceConfiguratorProvider.INSTANCE.orElse(null);
        if (provider != null) {
            for (CapabilityServiceConfigurator configurator : provider.getServerServiceConfigurators(name)) {
                configurator.configure(context).build(target).install();
            }
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        ModelNode parentModel = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false).getModel();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, parentModel).asString();
        boolean isDefaultServer = context.getCurrentAddressValue().equals(defaultServerName);
        if (isDefaultServer) {
            context.registerCapability(CommonWebServer.CAPABILITY);
        }
    }

    private void addCommonHostListenerDeps(OperationContext context, ServiceBuilder<WebServerService> builder, PathElement listenerPath) {
        ModelNode listeners = Resource.Tools.readModel((Resource)context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{listenerPath})), (int)1);
        if (listeners.isDefined()) {
            for (Property p : listeners.asPropertyList()) {
                for (Property listener : p.getValue().asPropertyList()) {
                    builder.addDependency(ListenerResourceDefinition.LISTENER_CAPABILITY.getCapabilityServiceName(new String[]{listener.getName()}));
                }
            }
        }
    }
}

