/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication.callback;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.auth.callback.MapCallback;

public class UsernameTokenCallbackHandler
implements CallbackHandler {
    private final String nonce;
    private final String created;
    private final boolean decodeNonce;

    public UsernameTokenCallbackHandler(String nonce, String created, boolean decodeNonce) {
        this.created = created;
        this.nonce = nonce;
        this.decodeNonce = decodeNonce;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        boolean foundCallback = false;
        Callback firstUnknown = null;
        int count = callbacks != null ? callbacks.length : 0;
        for (int n = 0; n < count; ++n) {
            Callback c = callbacks[n];
            if (c instanceof MapCallback) {
                MapCallback mc = (MapCallback)c;
                mc.setInfo("nonce", (Object)this.nonce);
                mc.setInfo("created", (Object)this.created);
                mc.setInfo("decodeNonce", (Object)this.decodeNonce);
                foundCallback = true;
                continue;
            }
            if (firstUnknown != null) continue;
            firstUnknown = c;
        }
        if (!foundCallback) {
            throw new UnsupportedCallbackException(firstUnknown, "Unrecognized Callback");
        }
    }
}

