/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLRequestAbstractParser;
import org.picketlink.identity.federation.core.parsers.util.SAMLParserUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;

public class SAMLSloRequestParser
extends SAMLRequestAbstractParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.LOGOUT_REQUEST.get());
        LogoutRequestType logoutRequest = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            this.parseCommonElements(startElement, xmlEventReader, logoutRequest);
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.SESSION_INDEX.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                logoutRequest.addSessionIndex(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.NAMEID.get().equals(elementName)) {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                logoutRequest.setNameID(nameID);
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equals(elementName) || JBossSAMLConstants.SIGNATURE.get().equals(elementName)) continue;
            throw logger.parserUnknownTag(elementName, startElement.getLocation());
        }
        return logoutRequest;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && JBossSAMLConstants.LOGOUT_REQUEST.equals((Object)qname.getLocalPart());
    }

    private LogoutRequestType parseBaseAttributes(StartElement startElement) throws ParsingException {
        Attribute notOnOrAfter;
        super.parseRequiredAttributes(startElement);
        LogoutRequestType logoutRequest = new LogoutRequestType(this.id, this.issueInstant);
        super.parseBaseAttributes(startElement, logoutRequest);
        Attribute reason = startElement.getAttributeByName(new QName(JBossSAMLConstants.REASON.get()));
        if (reason != null) {
            logoutRequest.setReason(StaxParserUtil.getAttributeValue((Attribute)reason));
        }
        if ((notOnOrAfter = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_ON_OR_AFTER.get()))) != null) {
            logoutRequest.setNotOnOrAfter(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)notOnOrAfter)));
        }
        return logoutRequest;
    }
}

