/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.xacml.core.model.context.ObjectFactory;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.ArtifactResolveType;
import org.picketlink.identity.federation.saml.v2.protocol.AttributeQueryType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnContextComparisonType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.NameIDPolicyType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestedAuthnContextType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLRequestWriter
extends BaseWriter {
    public SAMLRequestWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(AuthnRequestType request) throws ProcessingException {
        RequestedAuthnContextType requestedAuthnContext;
        NameIDPolicyType nameIDPolicy;
        Element sig;
        NameIDType issuer;
        String providerName;
        Integer attrIndex;
        Integer assertionIndex;
        URI protocolBinding;
        Boolean isPassive;
        Boolean forceAuthn;
        URI assertionURL;
        String consent;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.AUTHN_REQUEST.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)request.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)request.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.DESTINATION.get(), (String)destination.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(consent = request.getConsent()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONSENT.get(), (String)consent);
        }
        if ((assertionURL = request.getAssertionConsumerServiceURL()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_URL.get(), (String)assertionURL.toASCIIString());
        }
        if ((forceAuthn = request.isForceAuthn()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.FORCE_AUTHN.get(), (String)forceAuthn.toString());
        }
        if ((isPassive = request.isIsPassive()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.IS_PASSIVE.get(), (String)isPassive.toString());
        }
        if ((protocolBinding = request.getProtocolBinding()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.PROTOCOL_BINDING.get(), (String)protocolBinding.toString());
        }
        if ((assertionIndex = request.getAssertionConsumerServiceIndex()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_INDEX.get(), (String)assertionIndex.toString());
        }
        if ((attrIndex = request.getAttributeConsumingServiceIndex()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE_INDEX.get(), (String)attrIndex.toString());
        }
        if (StringUtil.isNotNull((String)(providerName = request.getProviderName()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.PROVIDER_NAME.get(), (String)providerName);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        if ((nameIDPolicy = request.getNameIDPolicy()) != null) {
            this.write(nameIDPolicy);
        }
        if ((requestedAuthnContext = request.getRequestedAuthnContext()) != null) {
            this.write(requestedAuthnContext);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(LogoutRequestType logOutRequest) throws ProcessingException {
        NameIDType nameID;
        String consent;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.LOGOUT_REQUEST.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)logOutRequest.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)logOutRequest.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)logOutRequest.getIssueInstant().toString());
        URI destination = logOutRequest.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.DESTINATION.get(), (String)destination.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(consent = logOutRequest.getConsent()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONSENT.get(), (String)consent);
        }
        NameIDType issuer = logOutRequest.getIssuer();
        this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        Element signature = logOutRequest.getSignature();
        if (signature != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)signature);
        }
        if ((nameID = logOutRequest.getNameID()) != null) {
            this.write(nameID, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
        }
        List<String> sessionIndexes = logOutRequest.getSessionIndex();
        for (String sessionIndex : sessionIndexes) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.SESSION_INDEX.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)sessionIndex);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            StaxUtil.flush((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(NameIDPolicyType nameIDPolicy) throws ProcessingException {
        Boolean allowCreate;
        String spNameQualifier;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.NAMEID_POLICY.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        URI format = nameIDPolicy.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.FORMAT.get(), (String)format.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(spNameQualifier = nameIDPolicy.getSPNameQualifier()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.SP_NAME_QUALIFIER.get(), (String)spNameQualifier);
        }
        if ((allowCreate = nameIDPolicy.isAllowCreate()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ALLOW_CREATE.get(), (String)allowCreate.toString());
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(RequestedAuthnContextType requestedAuthnContextType) throws ProcessingException {
        List<String> authnContextClassRef;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.REQUESTED_AUTHN_CONTEXT.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        AuthnContextComparisonType comparison = requestedAuthnContextType.getComparison();
        if (comparison != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.COMPARISON.get(), (String)comparison.value());
        }
        if ((authnContextClassRef = requestedAuthnContextType.getAuthnContextClassRef()) != null && !authnContextClassRef.isEmpty()) {
            for (String classRef : authnContextClassRef) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)classRef);
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(ArtifactResolveType request) throws ProcessingException {
        String artifact;
        Element sig;
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.ARTIFACT_RESOLVE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)request.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)request.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.DESTINATION.get(), (String)destination.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(consent = request.getConsent()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONSENT.get(), (String)consent);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        if (StringUtil.isNotNull((String)(artifact = request.getArtifact()))) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.ARTIFACT.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)artifact);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(AttributeQueryType request) throws ProcessingException {
        SubjectType subject;
        Element sig;
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE_QUERY.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)request.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)request.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.DESTINATION.get(), (String)destination.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(consent = request.getConsent()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONSENT.get(), (String)consent);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        if ((subject = request.getSubject()) != null) {
            this.write(subject);
        }
        List<AttributeType> attributes = request.getAttribute();
        for (AttributeType attr : attributes) {
            this.write(attr);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(XACMLAuthzDecisionQueryType xacmlQuery) throws ProcessingException {
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.REQUEST_ABSTRACT.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)XACML_SAML_PROTO_PREFIX, (String)JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.XACML_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)xacmlQuery.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)xacmlQuery.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)xacmlQuery.getIssueInstant().toString());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get(), JBossSAMLConstants.INPUT_CONTEXT_ONLY.get(), XACML_SAML_PROTO_PREFIX), (String)"true");
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get(), JBossSAMLConstants.RETURN_CONTEXT.get(), XACML_SAML_PROTO_PREFIX), (String)"true");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.XSI_PREFIX.get(), (String)JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"xs", (String)JBossSAMLURIConstants.XMLSCHEMA_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.XSI_NSURI.get(), (String)"type", (String)"xacml-samlp:XACMLAuthzDecisionQueryType");
        URI destination = xacmlQuery.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.DESTINATION.get(), (String)destination.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(consent = xacmlQuery.getConsent()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONSENT.get(), (String)consent);
        }
        if ((issuer = xacmlQuery.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        RequestType xacmlRequest = xacmlQuery.getRequest();
        ObjectFactory of = new ObjectFactory();
        StringWriter sw = new StringWriter();
        try {
            Marshaller m = JAXBUtil.getMarshaller(RequestType.class.getPackage().getName());
            m.marshal((Object)of.createRequest(xacmlRequest), (Writer)sw);
        }
        catch (JAXBException e) {
            throw logger.processingError((Throwable)e);
        }
        try {
            Document xacmlDoc = DocumentUtil.getDocument((String)sw.toString());
            StaxUtil.writeDOMNode((XMLStreamWriter)this.writer, (Node)xacmlDoc.getDocumentElement());
        }
        catch (ConfigurationException e) {
            throw logger.processingError((Throwable)e);
        }
        catch (ParsingException e) {
            throw logger.processingError((Throwable)e);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }
}

