/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class WildFlyBindingRegistry
implements BindingRegistry {
    private final ServiceContainer container;

    public WildFlyBindingRegistry(ServiceContainer container) {
        this.container = container;
    }

    public Object lookup(String name) {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        ServiceController bindingService = this.container.getService(bindInfo.getBinderServiceName());
        if (bindingService == null) {
            return null;
        }
        ManagedReferenceFactory managedReferenceFactory = (ManagedReferenceFactory)ManagedReferenceFactory.class.cast(bindingService.getValue());
        return managedReferenceFactory.getReference().getInstance();
    }

    public boolean bind(String name, Object obj) {
        if (name == null || name.isEmpty()) {
            throw MessagingLogger.ROOT_LOGGER.cannotBindJndiName();
        }
        BinderServiceUtil.installBinderService((ServiceTarget)this.container, name, obj);
        MessagingLogger.ROOT_LOGGER.boundJndiName(name);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) {
        if (name == null || name.isEmpty()) {
            throw MessagingLogger.ROOT_LOGGER.cannotUnbindJndiName();
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        ServiceController bindingService = this.container.getService(bindInfo.getBinderServiceName());
        if (bindingService == null) {
            MessagingLogger.ROOT_LOGGER.debugf("Cannot unbind %s since no binding exists with that name", name);
            return;
        }
        bindingService.setMode(ServiceController.Mode.REMOVE);
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(bindingService);
        try {
            monitor.awaitStability();
            MessagingLogger.ROOT_LOGGER.unboundJndiName(bindInfo.getAbsoluteJndiName());
        }
        catch (InterruptedException e) {
            MessagingLogger.ROOT_LOGGER.failedToUnbindJndiName(name, 5L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
        }
        finally {
            monitor.removeController(bindingService);
        }
    }

    public void close() {
    }
}

