/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.modules.Module;
import org.jboss.vfs.VFSUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldPortableExtensionProcessor
implements DeploymentUnitProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PrivateSubDeploymentMarker.isPrivate((DeploymentUnit)deploymentUnit) ? !WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit) : !WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.loadAttachments(module, deploymentUnit, extensions);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttachments(Module module, DeploymentUnit deploymentUnit, WeldPortableExtensions extensions) throws DeploymentUnitProcessingException {
        try {
            Enumeration resources = module.getClassLoader().getResources("META-INF/services/" + Extension.class.getName());
            ArrayList<String> services = new ArrayList<String>();
            while (resources.hasMoreElements()) {
                URL resource = (URL)resources.nextElement();
                InputStream stream = resource.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        int commentIdx = line.indexOf(35);
                        String className = commentIdx == -1 ? line.trim() : line.substring(0, commentIdx).trim();
                        if (className.length() == 0) continue;
                        services.add(className);
                    }
                }
                finally {
                    VFSUtils.safeClose((Closeable)stream);
                }
            }
            for (String service : services) {
                Class<Extension> extensionClass = this.loadExtension(service, (ClassLoader)module.getClassLoader());
                if (extensionClass == null) continue;
                extensions.tryRegisterExtension(extensionClass, deploymentUnit);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private Class<Extension> loadExtension(String serviceClassName, ClassLoader loader) throws DeploymentUnitProcessingException {
        try {
            return loader.loadClass(serviceClassName);
        }
        catch (Exception e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, (Throwable)e);
        }
        catch (LinkageError e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, (Throwable)e);
        }
        return null;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            deploymentUnit.removeAttachment(WeldPortableExtensions.ATTACHMENT_KEY);
        }
    }
}

