/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;

public class TransactionSynchronizer
implements Synchronization {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)TransactionSynchronizer.class.getName());
    private static ConcurrentMap<Object, Record> records = new ConcurrentHashMap<Object, Record>(512, 0.75f, 512);
    private Transaction tx;
    private Object identifier;
    private Thread enlistingThread;
    private List<Synchronization> unenlisted;
    private List<Synchronization> enlisted;
    private Synchronization ccmSynch;

    private TransactionSynchronizer(Transaction tx, Object id) {
        this.tx = tx;
        this.identifier = id;
        this.enlistingThread = null;
        this.unenlisted = new ArrayList<Synchronization>(1);
        this.enlisted = new ArrayList<Synchronization>(1);
    }

    public synchronized void addUnenlisted(Synchronization synch) {
        if (this.unenlisted == null) {
            this.unenlisted = new ArrayList<Synchronization>(1);
        }
        this.unenlisted.add(synch);
    }

    public synchronized List<Synchronization> getUnenlisted() {
        Thread currentThread = Thread.currentThread();
        while (this.enlistingThread != null && this.enlistingThread != currentThread) {
            boolean interrupted = false;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            if (!interrupted) continue;
            currentThread.interrupt();
        }
        List<Synchronization> result = this.unenlisted;
        this.unenlisted = null;
        if (result != null) {
            this.enlistingThread = currentThread;
        }
        return result;
    }

    public synchronized void addEnlisted(Synchronization synch) {
        this.enlisted.add(synch);
    }

    public synchronized boolean removeEnlisted(Synchronization synch) {
        return this.enlisted.remove(synch);
    }

    public synchronized void enlisted() {
        Thread currentThread = Thread.currentThread();
        if (this.enlistingThread == null || this.enlistingThread != currentThread) {
            log.threadIsnotEnlistingThread(currentThread, this.enlistingThread, new Exception("STACKTRACE"));
            return;
        }
        this.enlistingThread = null;
        this.notifyAll();
    }

    public static TransactionSynchronizer getRegisteredSynchronizer(Transaction tx, TransactionIntegration ti) throws SystemException, RollbackException {
        Record newRecord;
        Object id = ti.getIdentifier(tx);
        Record record = (Record)records.get(id);
        if (record == null && (record = records.putIfAbsent(id, newRecord = new Record(new ReentrantLock(true), new TransactionSynchronizer(tx, id)))) == null) {
            record = newRecord;
            if (log.isTraceEnabled()) {
                log.tracef("Adding: %s [%s]", System.identityHashCode(id), id.toString());
            }
            try {
                if (ti.getTransactionSynchronizationRegistry() != null) {
                    ti.getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)record.getTransactionSynchronizer());
                } else {
                    tx.registerSynchronization((Synchronization)record.getTransactionSynchronizer());
                }
            }
            catch (Throwable t) {
                records.remove(id);
                if (t instanceof SystemException) {
                    throw (SystemException)t;
                }
                if (t instanceof RollbackException) {
                    throw (RollbackException)t;
                }
                SystemException se = new SystemException(t.getMessage());
                se.initCause(t);
                throw se;
            }
        }
        return record.getTransactionSynchronizer();
    }

    public static Synchronization getCCMSynchronization(Transaction tx, TransactionIntegration ti) {
        Record record = (Record)records.get(ti.getIdentifier(tx));
        if (record != null) {
            return record.getTransactionSynchronizer().ccmSynch;
        }
        return null;
    }

    public static void registerCCMSynchronization(Transaction tx, Synchronization synch, TransactionIntegration ti) throws Exception {
        TransactionSynchronizer ts = TransactionSynchronizer.getRegisteredSynchronizer(tx, ti);
        ts.ccmSynch = synch;
    }

    public static void lock(Transaction tx, TransactionIntegration ti) throws SystemException, RollbackException {
        Record newRecord;
        Object id = ti.getIdentifier(tx);
        Record record = (Record)records.get(id);
        if (record == null && (record = records.putIfAbsent(id, newRecord = new Record(new ReentrantLock(true), new TransactionSynchronizer(tx, id)))) == null) {
            record = newRecord;
            if (log.isTraceEnabled()) {
                log.tracef("Adding: %s [%s]", System.identityHashCode(id), id.toString());
            }
            try {
                if (ti.getTransactionSynchronizationRegistry() != null) {
                    ti.getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)record.getTransactionSynchronizer());
                } else {
                    tx.registerSynchronization((Synchronization)record.getTransactionSynchronizer());
                }
            }
            catch (Throwable t) {
                records.remove(id);
                if (t instanceof SystemException) {
                    throw (SystemException)t;
                }
                if (t instanceof RollbackException) {
                    throw (RollbackException)t;
                }
                SystemException se = new SystemException(t.getMessage());
                se.initCause(t);
                throw se;
            }
        }
        Lock lock = record.getLock();
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get synchronization", e);
        }
    }

    public static void unlock(Transaction tx, TransactionIntegration ti) {
        Record record = (Record)records.get(ti.getIdentifier(tx));
        if (record != null) {
            record.getLock().unlock();
        }
    }

    public void beforeCompletion() {
        if (this.ccmSynch != null) {
            this.invokeBefore(this.ccmSynch);
        }
        for (Synchronization synch : this.enlisted) {
            this.invokeBefore(synch);
        }
    }

    public void afterCompletion(int status) {
        if (this.ccmSynch != null) {
            this.invokeAfter(this.ccmSynch, status);
        }
        for (Synchronization synch : this.enlisted) {
            this.invokeAfter(synch, status);
        }
        if (records.remove(this.identifier) == null) {
            Object altKey = null;
            Iterator iterator = records.entrySet().iterator();
            while (altKey == null && iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!((Record)next.getValue()).getTransactionSynchronizer().equals(this)) continue;
                altKey = next.getKey();
            }
            if (altKey != null) {
                records.remove(altKey);
                if (log.isTraceEnabled()) {
                    log.tracef("Removed: %s [%s]", System.identityHashCode(this.identifier), this.identifier.toString());
                }
            } else {
                log.transactionNotFound(this.identifier);
            }
        } else if (log.isTraceEnabled()) {
            log.tracef("Removed: %s [%s]", System.identityHashCode(this.identifier), this.identifier.toString());
        }
    }

    protected void invokeBefore(Synchronization synch) {
        try {
            synch.beforeCompletion();
        }
        catch (Throwable t) {
            log.transactionErrorInBeforeCompletion(this.tx, synch, t);
        }
    }

    protected void invokeAfter(Synchronization synch, int status) {
        try {
            synch.afterCompletion(status);
        }
        catch (Throwable t) {
            log.transactionErrorInAfterCompletion(this.tx, synch, t);
        }
    }

    static class Record {
        private Lock lock;
        private TransactionSynchronizer txSync;

        Record(Lock lock, TransactionSynchronizer txSync) {
            this.lock = lock;
            this.txSync = txSync;
        }

        Lock getLock() {
            return this.lock;
        }

        TransactionSynchronizer getTransactionSynchronizer() {
            return this.txSync;
        }
    }
}

