/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.jaspi.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.module.ClientAuthModule;
import org.jboss.security.config.ControlFlag;

public class JBossWSClientAuthContext
implements ClientAuthContext {
    private final List<ClientAuthModule> modules;
    private final Map<String, Map> moduleOptionsByName;
    protected List<ControlFlag> controlFlags = new ArrayList<ControlFlag>();

    public JBossWSClientAuthContext(List<ClientAuthModule> modules, Map<String, Map> moduleNameToOptions, CallbackHandler cbh) throws AuthException {
        this.modules = modules;
        this.moduleOptionsByName = moduleNameToOptions;
        for (ClientAuthModule cam : modules) {
            cam.initialize(null, null, cbh, this.moduleOptionsByName.get(cam.getClass().getName()));
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ClientAuthModule cam : this.modules) {
            cam.cleanSubject(messageInfo, subject);
        }
    }

    public void setControlFlags(List<ControlFlag> controlFlags) {
        this.controlFlags = controlFlags;
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        ClientAuthModule sam;
        AuthStatus status = null;
        Iterator<ClientAuthModule> iterator = this.modules.iterator();
        while (iterator.hasNext() && (status = (sam = iterator.next()).secureRequest(messageInfo, clientSubject)) != AuthStatus.FAILURE) {
        }
        return status;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        ClientAuthModule sam;
        AuthStatus status = null;
        Iterator<ClientAuthModule> iterator = this.modules.iterator();
        while (iterator.hasNext() && (status = (sam = iterator.next()).secureRequest(messageInfo, clientSubject)) != AuthStatus.FAILURE) {
        }
        return status;
    }
}

