/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import java.util.HashSet;
import java.util.Set;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.bridge.inbound.InboundBridge;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeManager;

public class InboundBridgeRecoveryModule
implements RecoveryModule {
    private static final Set<InboundBridge> recoveredBridges = new HashSet<InboundBridge>();
    private static final Logger LOG = Logger.getLogger(InboundBridgeRecoveryModule.class);
    private Set<Uid> firstPassUids;

    public static void addRecoveredBridge(InboundBridge bridge) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeRecoveryModule.addRecoveredBridge: " + bridge));
        }
        recoveredBridges.add(bridge);
    }

    public void periodicWorkFirstPass() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeRecoveryModule.periodicWorkFirstPass");
        }
        this.firstPassUids = this.getUidsToRecover();
    }

    public void periodicWorkSecondPass() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeRecoveryModule.periodicWorkSecondPass");
        }
        recoveredBridges.clear();
        Set<Uid> uids = this.getUidsToRecover();
        uids.retainAll(this.firstPassUids);
        for (Uid uid : uids) {
            try {
                SubordinateTransaction subordinateTransaction = SubordinationManager.getTransactionImporter().recoverTransaction(uid);
            }
            catch (XAException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.addBridgesToMapping();
    }

    private Set<Uid> getUidsToRecover() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeRecoveryModule.getUidsToRecover");
        }
        HashSet<Uid> uids = new HashSet<Uid>();
        try {
            RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
            InputObjectState states = new InputObjectState();
            if (recoveryStore.allObjUids(SubordinateAtomicAction.getType(), states) && states.notempty()) {
                boolean finished = false;
                do {
                    Uid uid;
                    if ((uid = UidHelper.unpackFrom((InputBuffer)states)).notEquals(Uid.nullUid())) {
                        SubordinateAtomicAction saa = new SubordinateAtomicAction(uid, true);
                        if (saa.getXid().getFormatId() != 131081) continue;
                        uids.add(uid);
                        continue;
                    }
                    finished = true;
                } while (!finished);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return uids;
    }

    private void addBridgesToMapping() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeRecoveryModule.addBridgesToMapping");
        }
        InboundBridgeManager inboundBridgeManager = InboundBridgeManager.getInstance();
        for (InboundBridge bridge : recoveredBridges) {
            if (inboundBridgeManager.addInboundBridge(bridge)) continue;
            XATerminator xaTerminator = SubordinationManager.getXATerminator();
            try {
                xaTerminator.rollback(bridge.getXid());
            }
            catch (XAException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

