/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.impl.transaction.TransactionContext;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.CacheException;

public class XaModeTransactionTable
implements TransactionTable {
    private static final Log log = LogFactory.getLog(XaModeTransactionTable.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Xid[] NO_XIDS = new Xid[0];
    private final Map<Transaction, XaAdapter> registeredTransactions = new ConcurrentHashMap<Transaction, XaAdapter>();
    private final Function<Transaction, XaAdapter> constructor = this::createTransactionData;

    @Override
    public <K, V> TransactionContext<K, V> enlist(TransactionalRemoteCacheImpl<K, V> txRemoteCache, Transaction tx) {
        XaAdapter xaAdapter = this.registeredTransactions.computeIfAbsent(tx, this.constructor);
        return xaAdapter.registerCache(txRemoteCache);
    }

    private XaAdapter createTransactionData(Transaction transaction) {
        XaAdapter xaAdapter = new XaAdapter(transaction);
        try {
            transaction.enlistResource((XAResource)xaAdapter);
        }
        catch (RollbackException | SystemException e) {
            throw new CacheException(e);
        }
        return xaAdapter;
    }

    private class XaAdapter
    implements XAResource {
        private final Transaction transaction;
        private final Map<String, TransactionContext<?, ?>> registeredCaches = new ConcurrentSkipListMap();
        private final Collection<TransactionContext<?, ?>> preparedCaches = new LinkedList();
        private volatile Xid currentXid;

        private XaAdapter(Transaction transaction) {
            this.transaction = transaction;
        }

        public String toString() {
            return "TransactionData{xid=" + this.currentXid + ", caches=" + this.registeredCaches.keySet() + '}';
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            if (trace) {
                log.tracef("XaResource.start(%s, %s)", xid, flags);
            }
            switch (flags) {
                case 0x200000: 
                case 0x8000000: {
                    if (this.currentXid != null && !this.currentXid.equals(xid)) {
                        throw new XAException(-9);
                    }
                    this.assertStartInvoked();
                    break;
                }
                case 0: {
                    if (this.currentXid != null) {
                        throw new XAException(-3);
                    }
                    this.currentXid = xid;
                    break;
                }
                default: {
                    throw new XAException(-3);
                }
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (trace) {
                log.tracef("XaResource.end(%s, %s)", xid, flags);
            }
            this.assertStartInvoked();
            this.assertSameXid(xid, -9);
            if (flags == 0x20000000) {
                this.registeredCaches.clear();
            }
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            if (trace) {
                log.tracef("XaResource.prepare(%s)", xid);
            }
            this.assertStartInvoked();
            this.assertSameXid(xid, -5);
            return this.internalPrepare();
        }

        @Override
        public void commit(Xid xid, boolean onePhaseCommit) throws XAException {
            if (trace) {
                log.tracef("XaResource.commit(%s, %s)", xid, onePhaseCommit);
            }
            this.assertStartInvoked();
            this.assertSameXid(xid, -5);
            try {
                if (onePhaseCommit) {
                    this.onePhaseCommit();
                } else {
                    this.internalCommit();
                }
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (trace) {
                log.tracef("XaResource.rollback(%s)", xid);
            }
            this.assertStartInvoked();
            this.assertSameXid(xid, -5);
            try {
                this.internalRollback();
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            if (trace) {
                log.tracef("XaResource.isSameRM(%s)", xaResource);
            }
            return xaResource == this;
        }

        @Override
        public void forget(Xid xid) {
            if (trace) {
                log.tracef("XaResource.forget(%s)", xid);
            }
        }

        @Override
        public Xid[] recover(int i) {
            return NO_XIDS;
        }

        @Override
        public boolean setTransactionTimeout(int i) {
            return false;
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        private void assertStartInvoked() throws XAException {
            if (this.currentXid == null) {
                throw new XAException(-4);
            }
        }

        private void assertSameXid(Xid otherXid, int xaErrorCode) throws XAException {
            if (!this.currentXid.equals(otherXid)) {
                throw new XAException(xaErrorCode);
            }
        }

        private void internalRollback() throws XAException {
            boolean hasCommit = false;
            boolean hasRollback = false;
            boolean alreadyForgot = false;
            boolean unknown = false;
            int unknownErrorCode = 0;
            block6: for (TransactionContext<?, ?> ctx : this.preparedCaches) {
                int xa_code = ctx.complete(this.currentXid, false);
                switch (xa_code) {
                    case 0: 
                    case 3: 
                    case 6: {
                        hasRollback = true;
                        continue block6;
                    }
                    case -4: {
                        alreadyForgot = true;
                        continue block6;
                    }
                    case 5: 
                    case 8: {
                        hasCommit = true;
                        hasRollback = true;
                        continue block6;
                    }
                    case 7: {
                        hasCommit = true;
                        continue block6;
                    }
                }
                unknown = true;
                unknownErrorCode = xa_code;
            }
            if (!hasCommit && !hasRollback) {
                if (alreadyForgot) {
                    throw new XAException(-4);
                }
                if (unknown) {
                    throw new XAException(unknownErrorCode);
                }
            } else {
                if (hasCommit && hasRollback) {
                    throw new XAException(5);
                }
                if (hasCommit) {
                    throw new XAException(7);
                }
            }
        }

        private void internalCommit() throws XAException {
            boolean hasCommit = false;
            boolean hasRollback = false;
            boolean alreadyForgot = false;
            boolean unknown = false;
            int unknownErrorCode = 0;
            block6: for (TransactionContext<?, ?> ctx : this.preparedCaches) {
                int xa_code = ctx.complete(this.currentXid, true);
                switch (xa_code) {
                    case 0: 
                    case 3: 
                    case 7: {
                        hasCommit = true;
                        continue block6;
                    }
                    case -4: {
                        alreadyForgot = true;
                        continue block6;
                    }
                    case 5: 
                    case 8: {
                        hasCommit = true;
                        hasRollback = true;
                        continue block6;
                    }
                    case 6: {
                        hasRollback = true;
                        continue block6;
                    }
                }
                unknown = true;
                unknownErrorCode = xa_code;
            }
            if (!hasCommit && !hasRollback) {
                if (alreadyForgot) {
                    throw new XAException(-4);
                }
                if (unknown) {
                    throw new XAException(unknownErrorCode);
                }
            } else {
                if (hasCommit && hasRollback) {
                    throw new XAException(5);
                }
                if (hasRollback) {
                    throw new XAException(6);
                }
            }
        }

        private int internalPrepare() throws XAException {
            boolean readOnly = true;
            block5: for (TransactionContext<?, ?> ctx : this.registeredCaches.values()) {
                switch (ctx.prepareContext(this.currentXid, false)) {
                    case 0: {
                        readOnly = false;
                        this.preparedCaches.add(ctx);
                        continue block5;
                    }
                    case 3: {
                        continue block5;
                    }
                    case -2147483648: {
                        throw new XAException(100);
                    }
                }
                this.preparedCaches.add(ctx);
                throw new XAException(100);
            }
            return readOnly ? 3 : 0;
        }

        private void onePhaseCommit() throws XAException {
            List txCaches = this.registeredCaches.values().stream().filter(TransactionContext::isReadWrite).collect(Collectors.toList());
            int size = txCaches.size();
            if (size == 0) {
                return;
            }
            boolean commit = true;
            block4: for (int i = 0; i < size - 1; ++i) {
                TransactionContext ctx = (TransactionContext)txCaches.get(i);
                switch (ctx.prepareContext(this.currentXid, false)) {
                    case 0: {
                        this.preparedCaches.add(ctx);
                        continue block4;
                    }
                    case -2147483648: {
                        commit = false;
                        break block4;
                    }
                    default: {
                        this.preparedCaches.add(ctx);
                        commit = false;
                        break block4;
                    }
                }
            }
            if (!commit || ((TransactionContext)txCaches.get(size - 1)).prepareContext(this.currentXid, true) != 0) {
                this.internalRollback();
                throw new XAException(100);
            }
            this.internalCommit();
        }

        private <K, V> TransactionContext<K, V> registerCache(TransactionalRemoteCacheImpl<K, V> txRemoteCache) {
            if (this.currentXid == null) {
                throw new CacheException("XaResource wasn't invoked!");
            }
            return this.registeredCaches.computeIfAbsent(txRemoteCache.getName(), s -> this.createTxContext(txRemoteCache));
        }

        private <K, V> TransactionContext<K, V> createTxContext(TransactionalRemoteCacheImpl<K, V> remoteCache) {
            if (trace) {
                log.tracef("Registering remote cache '%s' for transaction xid=%s", remoteCache.getName(), this.currentXid);
            }
            return new TransactionContext<K, V>(remoteCache.keyMarshaller(), remoteCache.valueMarshaller(), remoteCache.getOperationsFactory(), remoteCache.getName());
        }

        private void cleanup() {
            XaModeTransactionTable.this.registeredTransactions.remove(this.transaction);
            this.registeredCaches.clear();
            this.preparedCaches.clear();
            this.currentXid = null;
        }
    }
}

