/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.LinkedList;
import java.util.Queue;

public final class StartupCountdown {
    private static final ThreadLocal<Frame> frames = new ThreadLocal();
    private volatile int count;
    private final Queue<Runnable> callbacks = new LinkedList<Runnable>();

    public StartupCountdown(int count) {
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countDown() {
        StartupCountdown startupCountdown = this;
        synchronized (startupCountdown) {
            if (--this.count == 0) {
                try {
                    while (!this.callbacks.isEmpty()) {
                        this.callbacks.poll().run();
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countUp(int count) {
        StartupCountdown startupCountdown = this;
        synchronized (startupCountdown) {
            this.count += count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (this.isPrivileged()) {
            return;
        }
        if (this.count != 0) {
            StartupCountdown startupCountdown = this;
            synchronized (startupCountdown) {
                while (this.count != 0) {
                    this.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(Runnable callback) {
        StartupCountdown startupCountdown = this;
        synchronized (startupCountdown) {
            if (this.count != 0) {
                this.callbacks.add(callback);
            } else {
                callback.run();
            }
        }
    }

    public boolean isPrivileged() {
        Frame frame = frames.get();
        return frame != null && frame.contains(this);
    }

    public Frame enter() {
        Frame frame = frames.get();
        frames.set(new Frame(frame, this));
        return frame;
    }

    public static Frame current() {
        return frames.get();
    }

    public static void restore(Frame frame) {
        frames.set(frame);
    }

    public static final class Frame {
        private final Frame prev;
        private final StartupCountdown countdown;

        Frame(Frame prev, StartupCountdown countdown) {
            this.prev = prev;
            this.countdown = countdown;
        }

        boolean contains(StartupCountdown countdown) {
            return countdown == this.countdown || this.prev != null && this.prev.contains(countdown);
        }
    }
}

