/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.paging.cursor.NonExistentPage;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.jboss.logging.Logger;

public class RefsOperation
extends TransactionOperationAbstract {
    private static final Logger logger = Logger.getLogger(RefsOperation.class);
    private final StorageManager storageManager;
    private Queue queue;
    List<MessageReference> refsToAck = new ArrayList<MessageReference>();
    List<MessageReference> pagedMessagesToPostACK = null;
    protected boolean ignoreRedeliveryCheck = false;

    public RefsOperation(Queue queue, StorageManager storageManager) {
        this.queue = queue;
        this.storageManager = storageManager;
    }

    public void setIgnoreRedeliveryCheck() {
        this.ignoreRedeliveryCheck = true;
    }

    synchronized void addAck(MessageReference ref) {
        this.refsToAck.add(ref);
        if (ref.isPaged()) {
            if (this.pagedMessagesToPostACK == null) {
                this.pagedMessagesToPostACK = new ArrayList<MessageReference>();
            }
            this.pagedMessagesToPostACK.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRollback(Transaction tx) {
        HashMap<QueueImpl, LinkedList<MessageReference>> queueMap = new HashMap<QueueImpl, LinkedList<MessageReference>>();
        long timeBase = System.currentTimeMillis();
        ArrayList<MessageReference> ackedRefs = new ArrayList<MessageReference>();
        for (MessageReference messageReference : this.refsToAck) {
            messageReference.emptyConsumerID();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("rolling back " + messageReference));
            }
            try {
                if (messageReference.isAlreadyAcked()) {
                    ackedRefs.add(messageReference);
                }
                this.rollbackRedelivery(tx, messageReference, timeBase, queueMap);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCheckingDLQ(e);
            }
        }
        for (Map.Entry entry : queueMap.entrySet()) {
            QueueImpl queue;
            LinkedList refs = (LinkedList)entry.getValue();
            QueueImpl queueImpl = queue = (QueueImpl)entry.getKey();
            synchronized (queueImpl) {
                queue.postRollback(refs);
            }
        }
        if (!ackedRefs.isEmpty()) {
            try {
                TransactionImpl ackedTX = new TransactionImpl(this.storageManager);
                for (MessageReference ref : ackedRefs) {
                    Message message = ref.getMessage();
                    if (message.isDurable()) {
                        int durableRefCount = message.incrementDurableRefCount();
                        if (durableRefCount == 1) {
                            this.storageManager.storeMessageTransactional(ackedTX.getID(), message);
                        }
                        Queue queue = ref.getQueue();
                        this.storageManager.storeReferenceTransactional(ackedTX.getID(), queue.getID(), message.getMessageID());
                        ackedTX.setContainsPersistent();
                    }
                    message.incrementRefCount();
                }
                ackedTX.commit(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToProcessMessageReferenceAfterRollback(e);
            }
        }
    }

    protected void rollbackRedelivery(Transaction tx, MessageReference ref, long timeBase, Map<QueueImpl, LinkedList<MessageReference>> queueMap) throws Exception {
        if (ref.getQueue().checkRedelivery(ref, timeBase, this.ignoreRedeliveryCheck)) {
            LinkedList<MessageReference> toCancel = queueMap.get(ref.getQueue());
            if (toCancel == null) {
                toCancel = new LinkedList();
                queueMap.put((QueueImpl)ref.getQueue(), toCancel);
            }
            toCancel.addFirst(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCommit(Transaction tx) {
        for (MessageReference ref : this.refsToAck) {
            Queue queue = ref.getQueue();
            synchronized (queue) {
                this.queue.postAcknowledge(ref);
            }
        }
        if (this.pagedMessagesToPostACK != null) {
            for (MessageReference refmsg : this.pagedMessagesToPostACK) {
                if (!((PagedReference)refmsg).isLargeMessage()) continue;
                this.decrementRefCount(refmsg);
            }
        }
    }

    private void decrementRefCount(MessageReference refmsg) {
        try {
            refmsg.getMessage().decrementRefCount();
        }
        catch (NonExistentPage e) {
            logger.debug((Object)e);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToDecrementMessageReferenceCount(e);
        }
    }

    @Override
    public synchronized List<MessageReference> getRelatedMessageReferences() {
        LinkedList<MessageReference> listRet = new LinkedList<MessageReference>();
        listRet.addAll(listRet);
        return listRet;
    }

    @Override
    public synchronized List<MessageReference> getListOnConsumer(long consumerID) {
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        for (MessageReference ref : this.refsToAck) {
            if (!ref.hasConsumerId() || ref.getConsumerId() != consumerID) continue;
            list.add(ref);
        }
        return list;
    }

    public List<MessageReference> getReferencesToAcknowledge() {
        return this.refsToAck;
    }
}

