/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.jboss.logging.Logger;

final class JdbcLeaseLock
implements LeaseLock {
    private static final Logger LOGGER = Logger.getLogger(JdbcLeaseLock.class);
    private static final int MAX_HOLDER_ID_LENGTH = 128;
    private final Connection connection;
    private final String holderId;
    private final PreparedStatement tryAcquireLock;
    private final PreparedStatement tryReleaseLock;
    private final PreparedStatement renewLock;
    private final PreparedStatement isLocked;
    private final PreparedStatement currentDateTime;
    private final long expirationMillis;
    private boolean maybeAcquired;
    private final String lockName;

    JdbcLeaseLock(String holderId, Connection connection, PreparedStatement tryAcquireLock, PreparedStatement tryReleaseLock, PreparedStatement renewLock, PreparedStatement isLocked, PreparedStatement currentDateTime, long expirationMIllis, String lockName) {
        if (holderId.length() > 128) {
            throw new IllegalArgumentException("holderId length must be <=128");
        }
        this.holderId = holderId;
        this.tryAcquireLock = tryAcquireLock;
        this.tryReleaseLock = tryReleaseLock;
        this.renewLock = renewLock;
        this.isLocked = isLocked;
        this.currentDateTime = currentDateTime;
        this.expirationMillis = expirationMIllis;
        this.maybeAcquired = false;
        this.connection = connection;
        this.lockName = lockName;
    }

    public String holderId() {
        return this.holderId;
    }

    @Override
    public long expirationMillis() {
        return this.expirationMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readableLockStatus() {
        String string;
        this.connection.setTransactionIsolation(2);
        boolean autoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        try {
            String lockStatus;
            PreparedStatement preparedStatement = this.isLocked;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    lockStatus = null;
                } else {
                    String currentHolderId = resultSet.getString(1);
                    Timestamp expirationTime = resultSet.getTimestamp(2);
                    Timestamp currentTimestamp = resultSet.getTimestamp(3);
                    lockStatus = "holderId = " + currentHolderId + " expirationTime = " + expirationTime + " currentTimestamp = " + currentTimestamp;
                }
            }
            this.connection.commit();
            string = lockStatus;
        }
        catch (SQLException ie) {
            String string2;
            try {
                this.connection.rollback();
                string2 = ie.getMessage();
            }
            catch (Throwable throwable) {
                try {
                    this.connection.setAutoCommit(autoCommit);
                    throw throwable;
                }
                catch (SQLException e) {
                    return e.getMessage();
                }
            }
            this.connection.setAutoCommit(autoCommit);
            return string2;
        }
        this.connection.setAutoCommit(autoCommit);
        return string;
    }

    private long dbCurrentTimeMillis() throws SQLException {
        long start = System.nanoTime();
        try (ResultSet resultSet = this.currentDateTime.executeQuery();){
            resultSet.next();
            Timestamp currentTimestamp = resultSet.getTimestamp(1);
            long elapsedTime = System.nanoTime() - start;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("[%s] %s query currentTimestamp = %s tooks %d ms", new Object[]{this.lockName, this.holderId, currentTimestamp, TimeUnit.NANOSECONDS.toMillis(elapsedTime)});
            }
            long l = currentTimestamp.getTime();
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean renew() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    PreparedStatement preparedStatement = this.renewLock;
                    long now = this.dbCurrentTimeMillis();
                    Timestamp expirationTime = new Timestamp(now + this.expirationMillis);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("[%s] %s is renewing lock with expirationTime = %s", (Object)this.lockName, (Object)this.holderId, (Object)expirationTime);
                    }
                    preparedStatement.setTimestamp(1, expirationTime);
                    preparedStatement.setString(2, this.holderId);
                    preparedStatement.setTimestamp(3, expirationTime);
                    preparedStatement.setTimestamp(4, expirationTime);
                    int updatedRows = preparedStatement.executeUpdate();
                    boolean renewed = updatedRows == 1;
                    this.connection.commit();
                    if (!renewed) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debugf("[%s] %s has failed to renew lock: lock status = { %s }", (Object)this.lockName, (Object)this.holderId, (Object)this.readableLockStatus());
                        }
                    } else {
                        LOGGER.debugf("[%s] %s has renewed lock", (Object)this.lockName, (Object)this.holderId);
                    }
                    boolean bl = renewed;
                    return bl;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    throw new IllegalStateException(ie);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryAcquire() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    PreparedStatement preparedStatement = this.tryAcquireLock;
                    long now = this.dbCurrentTimeMillis();
                    preparedStatement.setString(1, this.holderId);
                    Timestamp expirationTime = new Timestamp(now + this.expirationMillis);
                    preparedStatement.setTimestamp(2, expirationTime);
                    preparedStatement.setTimestamp(3, expirationTime);
                    LOGGER.debugf("[%s] %s is trying to acquire lock with expirationTime %s", (Object)this.lockName, (Object)this.holderId, (Object)expirationTime);
                    boolean acquired = preparedStatement.executeUpdate() == 1;
                    this.connection.commit();
                    if (acquired) {
                        this.maybeAcquired = true;
                        LOGGER.debugf("[%s] %s has acquired lock", (Object)this.lockName, (Object)this.holderId);
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("[%s] %s has failed to acquire lock: lock status = { %s }", (Object)this.lockName, (Object)this.holderId, (Object)this.readableLockStatus());
                    }
                    boolean bl = acquired;
                    return bl;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    throw new IllegalStateException(ie);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public boolean isHeld() {
        return this.checkValidHolderId(Objects::nonNull);
    }

    @Override
    public boolean isHeldByCaller() {
        return this.checkValidHolderId(this.holderId::equals);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkValidHolderId(Predicate<? super String> holderIdFilter) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    boolean result;
                    block24: {
                        PreparedStatement preparedStatement = this.isLocked;
                        try (ResultSet resultSet = preparedStatement.executeQuery();){
                            long lockExpirationTime;
                            long expiredBy;
                            if (!resultSet.next()) {
                                result = false;
                                break block24;
                            }
                            String currentHolderId = resultSet.getString(1);
                            result = holderIdFilter.test(currentHolderId);
                            Timestamp expirationTime = resultSet.getTimestamp(2);
                            Timestamp currentTimestamp = resultSet.getTimestamp(3);
                            long currentTimestampMillis = currentTimestamp.getTime();
                            boolean zombie = false;
                            if (expirationTime != null && (expiredBy = currentTimestampMillis - (lockExpirationTime = expirationTime.getTime())) > 0L) {
                                result = false;
                                zombie = true;
                            }
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debugf("[%s] %s has found %s with holderId = %s expirationTime = %s currentTimestamp = %s", new Object[]{this.lockName, this.holderId, zombie ? "zombie lock" : "lock", currentHolderId, expirationTime, currentTimestamp});
                            }
                        }
                    }
                    this.connection.commit();
                    boolean bl = result;
                    return bl;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    throw new IllegalStateException(ie);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    PreparedStatement preparedStatement = this.tryReleaseLock;
                    preparedStatement.setString(1, this.holderId);
                    boolean released = preparedStatement.executeUpdate() == 1;
                    this.maybeAcquired = false;
                    this.connection.commit();
                    if (!released) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debugf("[%s] %s has failed to release lock: lock status = { %s }", (Object)this.lockName, (Object)this.holderId, (Object)this.readableLockStatus());
                        }
                    } else {
                        LOGGER.debugf("[%s] %s has released lock", (Object)this.lockName, (Object)this.holderId);
                    }
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    throw new IllegalStateException(ie);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (!this.tryReleaseLock.isClosed()) {
                try {
                    if (this.maybeAcquired) {
                        this.release();
                    }
                }
                finally {
                    this.tryReleaseLock.close();
                    this.tryAcquireLock.close();
                    this.renewLock.close();
                    this.isLocked.close();
                    this.currentDateTime.close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

