/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.Version;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.DefaultAuthenticationContextProvider;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.RuleNode;

public final class AuthenticationContext
implements Contextual<AuthenticationContext> {
    private static final ContextManager<AuthenticationContext> CONTEXT_MANAGER = new ContextManager(AuthenticationContext.class);
    private static final Supplier<AuthenticationContext> SUPPLIER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    final RuleNode<AuthenticationConfiguration> authRules;
    final RuleNode<SecurityFactory<SSLContext>> sslRules;
    static final AuthenticationContext EMPTY;

    private AuthenticationContext() {
        this(null, null);
    }

    AuthenticationContext(RuleNode<AuthenticationConfiguration> authRules, RuleNode<SecurityFactory<SSLContext>> sslRules) {
        this.authRules = authRules;
        this.sslRules = sslRules;
    }

    public static AuthenticationContext empty() {
        return EMPTY;
    }

    public static AuthenticationContext captureCurrent() {
        return SUPPLIER.get();
    }

    private static <T> RuleNode<T> with(RuleNode<T> node, MatchRule rule, T item) {
        return node == null ? new RuleNode<T>(null, rule, item) : node.with(rule, item);
    }

    private static <T> RuleNode<T> with(RuleNode<T> node, MatchRule rule, T item, int idx) {
        return node == null ? new RuleNode<T>(null, rule, item) : node.with(rule, item, idx);
    }

    private static <T> RuleNode<T> replacing(RuleNode<T> node, MatchRule rule, T item, int idx) {
        return node == null ? new RuleNode<T>(null, rule, item) : node.replacing(rule, item, idx);
    }

    private static <T> RuleNode<T> withAll(RuleNode<T> node, RuleNode<T> otherNode) {
        return node == null ? otherNode : (otherNode == null ? node : node.withAll(otherNode));
    }

    private static <T> RuleNode<T> withAll(RuleNode<T> node, RuleNode<T> otherNode, int idx) {
        return node == null ? otherNode : (otherNode == null ? node : node.withAll(otherNode, idx));
    }

    private static <T> RuleNode<T> without(RuleNode<T> node, int idx) {
        return node == null ? null : node.without(idx);
    }

    public AuthenticationContext with(MatchRule rule, AuthenticationConfiguration configuration) {
        if (configuration == null || rule == null) {
            return this;
        }
        return new AuthenticationContext(AuthenticationContext.with(this.authRules, rule, configuration), this.sslRules);
    }

    public AuthenticationContext withSsl(MatchRule rule, SecurityFactory<SSLContext> sslContext) {
        if (sslContext == null || rule == null) {
            return this;
        }
        return new AuthenticationContext(this.authRules, AuthenticationContext.with(this.sslRules, rule, sslContext));
    }

    public AuthenticationContext with(AuthenticationContext other) {
        if (other == null) {
            return this;
        }
        return new AuthenticationContext(AuthenticationContext.withAll(this.authRules, other.authRules), AuthenticationContext.withAll(this.sslRules, other.sslRules));
    }

    public AuthenticationContext with(int idx, MatchRule rule, AuthenticationConfiguration configuration) throws IndexOutOfBoundsException {
        if (configuration == null || rule == null) {
            return this;
        }
        return new AuthenticationContext(AuthenticationContext.with(this.authRules, rule, configuration, idx), this.sslRules);
    }

    public AuthenticationContext withSsl(int idx, MatchRule rule, SecurityFactory<SSLContext> sslContext) throws IndexOutOfBoundsException {
        if (sslContext == null || rule == null) {
            return this;
        }
        return new AuthenticationContext(this.authRules, AuthenticationContext.with(this.sslRules, rule, sslContext, idx));
    }

    public AuthenticationContext replacing(int idx, MatchRule rule, AuthenticationConfiguration configuration) throws IndexOutOfBoundsException {
        if (configuration == null || rule == null) {
            return this;
        }
        return new AuthenticationContext(AuthenticationContext.replacing(this.authRules, rule, configuration, idx), this.sslRules);
    }

    public AuthenticationContext replacingSslContext(int idx, MatchRule rule, SecurityFactory<SSLContext> sslContext) throws IndexOutOfBoundsException {
        if (sslContext == null || rule == null) {
            return this;
        }
        return new AuthenticationContext(this.authRules, AuthenticationContext.replacing(this.sslRules, rule, sslContext, idx));
    }

    public AuthenticationContext without(int idx) throws IndexOutOfBoundsException {
        return new AuthenticationContext(AuthenticationContext.without(this.authRules, idx), this.sslRules);
    }

    public AuthenticationContext withoutSsl(int idx) throws IndexOutOfBoundsException {
        return new AuthenticationContext(this.authRules, AuthenticationContext.without(this.sslRules, idx));
    }

    RuleNode<AuthenticationConfiguration> authRuleMatching(URI uri, String abstractType, String abstractTypeAuthority) {
        for (RuleNode<AuthenticationConfiguration> node = this.authRules; node != null; node = node.getNext()) {
            if (!node.getRule().matches(uri, abstractType, abstractTypeAuthority)) continue;
            return node;
        }
        return null;
    }

    RuleNode<SecurityFactory<SSLContext>> sslRuleMatching(URI uri, String abstractType, String abstractTypeAuthority) {
        for (RuleNode<SecurityFactory<SSLContext>> node = this.sslRules; node != null; node = node.getNext()) {
            if (!node.getRule().matches(uri, abstractType, abstractTypeAuthority)) continue;
            return node;
        }
        return null;
    }

    public <T> T run(PrivilegedAction<T> action) {
        return (T)this.runAction(action);
    }

    public <T> T run(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return (T)this.runExceptionAction(action);
    }

    public <T, P> T run(P parameter, ParametricPrivilegedAction<T, P> action) {
        return (T)this.runFunction((Function)action, parameter);
    }

    public <T, P> T run(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        try {
            return (T)this.runExFunction((ExceptionFunction)action, parameter);
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public <T> void runAsObjIntConsumer(ObjIntConsumer<T> action, T parameter1, int parameter2) {
        this.runBiConsumer(action::accept, parameter1, parameter2);
    }

    public <T> T runAsSupplier(Supplier<T> action) {
        return (T)this.runFunction(Supplier::get, action);
    }

    public <T, E extends Exception> void runAsObjIntConsumerEx(ExceptionObjIntConsumer<T, E> action, T parameter1, int parameter2) throws E {
        this.runExBiConsumer((arg_0, arg_1) -> action.accept(arg_0, arg_1), parameter1, parameter2);
    }

    public <T, E extends Exception> T runAsSupplierEx(ExceptionSupplier<T, E> action) throws E {
        return (T)this.runExFunction(ExceptionSupplier::get, action);
    }

    public ContextManager<AuthenticationContext> getInstanceContextManager() {
        return AuthenticationContext.getContextManager();
    }

    public static ContextManager<AuthenticationContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    static {
        Version.getVersion();
        CONTEXT_MANAGER.setGlobalDefaultSupplier(() -> DefaultAuthenticationContextProvider.DEFAULT);
        EMPTY = new AuthenticationContext();
    }
}

