/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.executors.LazyInitializingExecutorService;
import org.infinispan.executors.LazyInitializingScheduledExecutorService;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;

@DefaultFactoryFor(names={"org.infinispan.executors.transport", "org.infinispan.executors.notification", "org.infinispan.executors.persistence", "org.infinispan.executors.async", "org.infinispan.executors.expiration", "org.infinispan.executors.remote", "org.infinispan.executors.stateTransferExecutor", "org.infinispan.executors.timeout"})
public class NamedExecutorsFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    private ExecutorService notificationExecutor;
    private ExecutorService asyncTransportExecutor;
    private ExecutorService persistenceExecutor;
    private BlockingTaskAwareExecutorService remoteCommandsExecutor;
    private ScheduledExecutorService expirationExecutor;
    private ExecutorService stateTransferExecutor;
    private ExecutorService asyncOperationsExecutor;
    private ScheduledExecutorService timeoutExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object construct(String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.notificationExecutor == null) {
                        this.notificationExecutor = this.createExecutorService(this.globalConfiguration.listenerThreadPool(), "org.infinispan.executors.notification", ExecutorServiceType.DEFAULT);
                    }
                }
                return this.notificationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.persistence")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.persistenceExecutor == null) {
                        this.persistenceExecutor = this.createExecutorService(this.globalConfiguration.persistenceThreadPool(), "org.infinispan.executors.persistence", ExecutorServiceType.SCHEDULED);
                    }
                }
                return this.persistenceExecutor;
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncTransportExecutor == null) {
                        this.asyncTransportExecutor = this.createExecutorService(this.globalConfiguration.transport().transportThreadPool(), "org.infinispan.executors.transport", ExecutorServiceType.DEFAULT);
                    }
                }
                return this.asyncTransportExecutor;
            }
            if (componentName.equals("org.infinispan.executors.expiration")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.expirationExecutor == null) {
                        this.expirationExecutor = (ScheduledExecutorService)this.createExecutorService(this.globalConfiguration.expirationThreadPool(), "org.infinispan.executors.expiration", ExecutorServiceType.SCHEDULED);
                    }
                }
                return this.expirationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.remote")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.remoteCommandsExecutor == null) {
                        this.remoteCommandsExecutor = (BlockingTaskAwareExecutorService)this.createExecutorService(this.globalConfiguration.transport().remoteCommandThreadPool(), "org.infinispan.executors.remote", ExecutorServiceType.BLOCKING);
                    }
                }
                return this.remoteCommandsExecutor;
            }
            if (componentName.equals("org.infinispan.executors.stateTransferExecutor")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.stateTransferExecutor == null) {
                        this.stateTransferExecutor = this.createExecutorService(this.globalConfiguration.stateTransferThreadPool(), "org.infinispan.executors.stateTransferExecutor", ExecutorServiceType.DEFAULT);
                    }
                }
                return this.stateTransferExecutor;
            }
            if (componentName.equals("org.infinispan.executors.async")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncOperationsExecutor == null) {
                        this.asyncOperationsExecutor = this.createExecutorService(this.globalConfiguration.asyncThreadPool(), "org.infinispan.executors.async", ExecutorServiceType.DEFAULT);
                    }
                }
                return this.asyncOperationsExecutor;
            }
            if (componentName.endsWith("org.infinispan.executors.timeout")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.timeoutExecutor == null) {
                        this.timeoutExecutor = (ScheduledExecutorService)this.createExecutorService(null, "org.infinispan.executors.timeout", ExecutorServiceType.SCHEDULED);
                    }
                }
                return this.timeoutExecutor;
            }
            throw new CacheConfigurationException("Unknown named executor " + componentName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, (Throwable)e);
        }
    }

    @Stop(priority=999)
    public void stop() {
        if (this.remoteCommandsExecutor != null) {
            this.remoteCommandsExecutor.shutdownNow();
        }
        if (this.notificationExecutor != null) {
            this.notificationExecutor.shutdownNow();
        }
        if (this.persistenceExecutor != null) {
            this.persistenceExecutor.shutdownNow();
        }
        if (this.asyncTransportExecutor != null) {
            this.asyncTransportExecutor.shutdownNow();
        }
        if (this.expirationExecutor != null) {
            this.expirationExecutor.shutdownNow();
        }
        if (this.stateTransferExecutor != null) {
            this.stateTransferExecutor.shutdownNow();
        }
        if (this.timeoutExecutor != null) {
            this.timeoutExecutor.shutdownNow();
        }
        if (this.asyncOperationsExecutor != null) {
            this.asyncOperationsExecutor.shutdownNow();
        }
    }

    private <T extends ExecutorService> T createExecutorService(ThreadPoolConfiguration threadPoolConfiguration, String componentName, ExecutorServiceType type) {
        Object executorFactory;
        ThreadFactory threadFactory;
        if (threadPoolConfiguration != null) {
            threadFactory = threadPoolConfiguration.threadFactory() != null ? threadPoolConfiguration.threadFactory() : this.createThreadFactoryWithDefaults(this.globalConfiguration, componentName);
            executorFactory = threadPoolConfiguration.threadPoolFactory() != null ? threadPoolConfiguration.threadPoolFactory() : this.createThreadPoolFactoryWithDefaults(componentName, type);
        } else {
            threadFactory = this.createThreadFactoryWithDefaults(this.globalConfiguration, componentName);
            executorFactory = this.createThreadPoolFactoryWithDefaults(componentName, type);
        }
        switch (type) {
            case SCHEDULED: {
                return (T)new LazyInitializingScheduledExecutorService((ThreadPoolExecutorFactory<ScheduledExecutorService>)executorFactory, threadFactory);
            }
            case BLOCKING: {
                String controllerName = "Controller-" + KnownComponentNames.shortened(componentName) + "-" + this.globalConfiguration.transport().nodeName();
                return (T)new LazyInitializingBlockingTaskAwareExecutorService((ThreadPoolExecutorFactory<ExecutorService>)executorFactory, threadFactory, this.globalComponentRegistry.getTimeService(), controllerName);
            }
        }
        return (T)new LazyInitializingExecutorService((ThreadPoolExecutorFactory<ExecutorService>)executorFactory, threadFactory);
    }

    private ThreadFactory createThreadFactoryWithDefaults(GlobalConfiguration globalCfg, String componentName) {
        return new DefaultThreadFactory(null, KnownComponentNames.getDefaultThreadPrio(componentName), "%c-%n-p%f-t%t", globalCfg.transport().nodeName(), KnownComponentNames.shortened(componentName));
    }

    private ThreadPoolExecutorFactory createThreadPoolFactoryWithDefaults(String componentName, ExecutorServiceType type) {
        switch (type) {
            case SCHEDULED: {
                return ScheduledThreadPoolExecutorFactory.create();
            }
        }
        int defaultQueueSize = KnownComponentNames.getDefaultQueueSize(componentName);
        int defaultMaxThreads = KnownComponentNames.getDefaultThreads(componentName);
        return BlockingThreadPoolExecutorFactory.create((int)defaultMaxThreads, (int)defaultQueueSize);
    }

    private static enum ExecutorServiceType {
        DEFAULT,
        SCHEDULED,
        BLOCKING;

    }
}

