/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.util.Arrays;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class ClassToExternalizerMap {
    private static final Log log = LogFactory.getLog(ClassToExternalizerMap.class);
    private AdvancedExternalizer[] values;
    private Class[] keys;
    private int count;
    private int resizeCount;
    private final float loadFactor;

    public ClassToExternalizerMap(int initialCapacity, float loadF) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        if (loadF <= 0.0f || loadF >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0.0 and < 1.0");
        }
        if (initialCapacity < 16) {
            initialCapacity = 16;
        } else {
            int c = Integer.highestOneBit(initialCapacity) - 1;
            initialCapacity = Integer.highestOneBit(initialCapacity + c);
        }
        this.keys = new Class[initialCapacity];
        this.values = new AdvancedExternalizer[initialCapacity];
        this.resizeCount = (int)((double)initialCapacity * (double)loadF);
        this.loadFactor = loadF;
    }

    public ClassToExternalizerMap(float loadFactor) {
        this(64, loadFactor);
    }

    public ClassToExternalizerMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public ClassToExternalizerMap() {
        this(0.5f);
    }

    public AdvancedExternalizer get(Class key) {
        Class[] keys = this.keys;
        int mask = keys.length - 1;
        int hc = System.identityHashCode(key) & mask;
        Class k;
        while ((k = keys[hc]) != key) {
            if (k == null) {
                return null;
            }
            hc = hc + 1 & mask;
        }
        return this.values[hc];
    }

    public void put(Class key, AdvancedExternalizer value) {
        int hc;
        Class[] keys = this.keys;
        int mask = keys.length - 1;
        AdvancedExternalizer[] values = this.values;
        int idx = hc = System.identityHashCode(key) & mask;
        while (true) {
            Class k;
            if ((k = keys[idx]) == null) {
                keys[idx] = key;
                values[idx] = value;
                if (++this.count > this.resizeCount) {
                    this.resize();
                }
                return;
            }
            if (k == key) {
                values[idx] = value;
                return;
            }
            idx = hc++ & mask;
        }
    }

    private void resize() {
        Class[] oldKeys = this.keys;
        int oldsize = oldKeys.length;
        AdvancedExternalizer[] oldValues = this.values;
        if (oldsize >= 0x40000000) {
            throw new IllegalStateException("Table full");
        }
        int newsize = oldsize << 1;
        int mask = newsize - 1;
        Class[] newKeys = new Class[newsize];
        AdvancedExternalizer[] newValues = new AdvancedExternalizer[newsize];
        this.keys = newKeys;
        this.values = newValues;
        if ((this.resizeCount <<= 1) == 0) {
            this.resizeCount = Integer.MAX_VALUE;
        }
        block0: for (int oi = 0; oi < oldsize; ++oi) {
            Class key = oldKeys[oi];
            if (key == null) continue;
            int ni = System.identityHashCode(key) & mask;
            while (true) {
                Class v;
                if ((v = newKeys[ni]) == null) {
                    newKeys[ni] = key;
                    newValues[ni] = oldValues[oi];
                    continue block0;
                }
                ni = ni + 1 & mask;
            }
        }
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
        this.count = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Map length = ").append(this.keys.length).append(", count = ").append(this.count).append(", resize count = ").append(this.resizeCount).append('\n');
        for (int i = 0; i < this.keys.length; ++i) {
            builder.append('[').append(i).append("] = ");
            if (this.keys[i] != null) {
                int hc = System.identityHashCode(this.keys[i]);
                builder.append("{ ").append(this.keys[i]).append(" (hash ").append(hc).append(", modulus ").append(hc % this.keys.length).append(") => ").append(this.values[i]).append(" }");
            } else {
                builder.append("(blank)");
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    public IdToExternalizerMap reverseMap() {
        IdToExternalizerHashMap reverse = new IdToExternalizerHashMap(8, this.loadFactor);
        this.fillReverseMap(reverse);
        return reverse;
    }

    public IdToExternalizerMap reverseMap(int maxId) {
        IdToExternalizerArrayMap reverse = new IdToExternalizerArrayMap(maxId);
        this.fillReverseMap(reverse);
        return reverse;
    }

    private void fillReverseMap(IdToExternalizerMap reverse) {
        for (AdvancedExternalizer ext : this.values) {
            if (ext == null) continue;
            AdvancedExternalizer prev = reverse.get(ext.getId());
            if (prev != null && !prev.equals(ext)) {
                throw log.duplicateExternalizerIdFound(ext.getId(), prev.getClass().getName());
            }
            reverse.put(ext.getId(), ext);
        }
    }

    private static final class IdToExternalizerHashMap
    implements IdToExternalizerMap {
        private AdvancedExternalizer[] values;
        private int[] keys;
        private int count;
        private int resizeCount;

        private IdToExternalizerHashMap(int initialCapacity, float loadFactor) {
            if (initialCapacity < 1) {
                throw new IllegalArgumentException("initialCapacity must be > 0");
            }
            if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
                throw new IllegalArgumentException("loadFactor must be > 0.0 and < 1.0");
            }
            if (initialCapacity < 16) {
                initialCapacity = 16;
            } else {
                int c = Integer.highestOneBit(initialCapacity) - 1;
                initialCapacity = Integer.highestOneBit(initialCapacity + c);
            }
            this.keys = new int[initialCapacity];
            this.values = new AdvancedExternalizer[initialCapacity];
            this.resizeCount = (int)((double)initialCapacity * (double)loadFactor);
        }

        @Override
        public AdvancedExternalizer get(int key) {
            int[] keys = this.keys;
            AdvancedExternalizer[] values = this.values;
            int mask = keys.length - 1;
            int hc = key & mask;
            int k;
            while ((k = keys[hc]) != key) {
                if (values[hc] == null) {
                    return null;
                }
                hc = hc + 1 & mask;
            }
            return values[hc];
        }

        @Override
        public void put(int key, AdvancedExternalizer value) {
            int hc;
            int[] keys = this.keys;
            int mask = keys.length - 1;
            AdvancedExternalizer[] values = this.values;
            int idx = hc = key & mask;
            while (true) {
                int k = keys[idx];
                if (values[idx] == null) {
                    keys[idx] = key;
                    values[idx] = value;
                    if (++this.count > this.resizeCount) {
                        this.resize();
                    }
                    return;
                }
                if (k == key) {
                    values[idx] = value;
                    return;
                }
                idx = hc++ & mask;
            }
        }

        private void resize() {
            int[] oldKeys = this.keys;
            int oldsize = oldKeys.length;
            AdvancedExternalizer[] oldValues = this.values;
            if (oldsize >= 0x40000000) {
                throw new IllegalStateException("Table full");
            }
            int newsize = oldsize << 1;
            int mask = newsize - 1;
            int[] newKeys = new int[newsize];
            AdvancedExternalizer[] newValues = new AdvancedExternalizer[newsize];
            this.keys = newKeys;
            this.values = newValues;
            if ((this.resizeCount <<= 1) == 0) {
                this.resizeCount = Integer.MAX_VALUE;
            }
            block0: for (int oi = 0; oi < oldsize; ++oi) {
                int key = oldKeys[oi];
                if (oldValues[oi] == null) continue;
                int ni = key & mask;
                while (true) {
                    if (newValues[ni] == null) {
                        newKeys[ni] = key;
                        newValues[ni] = oldValues[oi];
                        continue block0;
                    }
                    ni = ni + 1 & mask;
                }
            }
        }

        @Override
        public void clear() {
            Arrays.fill(this.keys, 0);
            this.count = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Map length = ").append(this.keys.length).append(", count = ").append(this.count).append(", resize count = ").append(this.resizeCount).append('\n');
            for (int i = 0; i < this.keys.length; ++i) {
                builder.append('[').append(i).append("] = ");
                if (this.values[i] != null) {
                    int hc = this.keys[i];
                    builder.append("{ ").append(this.keys[i]).append(" (hash ").append(hc).append(", modulus ").append(hc % this.keys.length).append(") => ").append(this.values[i]).append(" }");
                } else {
                    builder.append("(blank)");
                }
                builder.append('\n');
            }
            return builder.toString();
        }
    }

    private static final class IdToExternalizerArrayMap
    implements IdToExternalizerMap {
        private AdvancedExternalizer[] values;
        private int count;

        private IdToExternalizerArrayMap(int initialCapacity) {
            if (initialCapacity < 1) {
                throw new IllegalArgumentException("initialCapacity must be > 0");
            }
            if (initialCapacity < 16) {
                initialCapacity = 16;
            } else {
                int c = Integer.highestOneBit(initialCapacity) - 1;
                initialCapacity = Integer.highestOneBit(initialCapacity + c);
            }
            this.values = new AdvancedExternalizer[initialCapacity];
        }

        @Override
        public AdvancedExternalizer get(int key) {
            AdvancedExternalizer[] values = this.values;
            return values[key];
        }

        @Override
        public void put(int key, AdvancedExternalizer value) {
            AdvancedExternalizer[] values = this.values;
            if (values[key] == null) {
                values[key] = value;
                if (++this.count > values.length) {
                    this.resize();
                }
            }
        }

        private void resize() {
            AdvancedExternalizer[] oldValues = this.values;
            int oldsize = oldValues.length;
            if (oldsize >= 0x40000000) {
                throw new IllegalStateException("Table full");
            }
            int newsize = oldsize << 1;
            AdvancedExternalizer[] newValues = new AdvancedExternalizer[newsize];
            this.values = newValues;
            for (int oi = 0; oi < oldsize; ++oi) {
                if (oldValues[oi] == null) continue;
                newValues[oi] = oldValues[oi];
            }
        }

        @Override
        public void clear() {
            Arrays.fill(this.values, null);
            this.count = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Map length = ").append(this.values.length).append(", count = ").append(this.count).append('\n');
            for (int i = 0; i < this.values.length; ++i) {
                builder.append('[').append(i).append("] = ");
                if (this.values[i] != null) {
                    builder.append("{ ").append(this.values[i]).append("}");
                } else {
                    builder.append("(blank)");
                }
                builder.append('\n');
            }
            return builder.toString();
        }
    }

    static interface IdToExternalizerMap {
        public AdvancedExternalizer get(int var1);

        public void put(int var1, AdvancedExternalizer var2);

        public void clear();
    }
}

