/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class SecurityActions {
    private static final Log log = LogFactory.getLog(SecurityActions.class);

    SecurityActions() {
    }

    private static Field getDeclaredField(Class<?> c, String fieldName) {
        try {
            return c.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    static Field getField(Class<?> c, String fieldName) {
        Field field;
        if (System.getSecurityManager() != null) {
            field = AccessController.doPrivileged(() -> {
                Field f = SecurityActions.getDeclaredField(c, fieldName);
                if (f != null) {
                    f.setAccessible(true);
                }
                return f;
            });
        } else {
            field = SecurityActions.getDeclaredField(c, fieldName);
            if (field != null) {
                field.setAccessible(true);
            }
        }
        return field;
    }

    private static <T> Constructor<T> doGetConstructor(Class<T> c, Class<?> ... parameterTypes) {
        try {
            return c.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static <T> Constructor<T> getConstructor(Class<T> c, Class<?> ... parameterTypes) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> SecurityActions.doGetConstructor(c, parameterTypes));
        }
        return SecurityActions.doGetConstructor(c, parameterTypes);
    }
}

