/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class CertificatePoliciesExtension
extends X509CertificateExtension {
    private final List<PolicyInformation> policyInformationList;

    public CertificatePoliciesExtension(boolean critical, List<PolicyInformation> policyInformationList) {
        super(critical);
        Assert.checkNotNullParam("policyInformationList", policyInformationList);
        this.policyInformationList = policyInformationList;
    }

    @Override
    public String getId() {
        return "2.5.29.32";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (PolicyInformation policy : this.policyInformationList) {
            policy.encodeTo(encoder);
        }
        encoder.endSequence();
    }

    public static final class PolicyQualifier
    implements ASN1Encodable {
        private final String policyQualifierId;
        private final ASN1Encodable body;

        public PolicyQualifier(String policyQualifierId, ASN1Encodable body) {
            Assert.checkNotNullParam("policyQualifierId", policyQualifierId);
            Assert.checkNotNullParam("body", body);
            this.policyQualifierId = policyQualifierId;
            this.body = body;
        }

        @Override
        public void encodeTo(ASN1Encoder encoder) {
            encoder.startSequence();
            encoder.encodeObjectIdentifier(this.policyQualifierId);
            this.body.encodeTo(encoder);
            encoder.endSequence();
        }

        public static PolicyQualifier userNoticeQualifier(String organizationText, BigInteger[] noticeNumbers, String explicitText) {
            return new PolicyQualifier("1.3.6.1.5.5.7.2.2", encoder -> {
                encoder.startSequence();
                if (organizationText != null) {
                    encoder.startSequence();
                    encoder.encodeUTF8String(organizationText);
                    encoder.startSequence();
                    if (noticeNumbers != null) {
                        for (BigInteger noticeNumber : noticeNumbers) {
                            encoder.encodeInteger(noticeNumber);
                        }
                    }
                    encoder.endSequence();
                    encoder.endSequence();
                }
                if (explicitText != null) {
                    encoder.encodeUTF8String(explicitText);
                }
                encoder.endSequence();
            });
        }

        public static PolicyQualifier cpsQualifier(String uri) {
            return new PolicyQualifier("1.3.6.1.5.5.7.2.1", encoder -> encoder.encodeIA5String(uri));
        }
    }

    public static final class PolicyInformation
    implements ASN1Encodable {
        private final String policyIdentifier;
        private final List<PolicyQualifier> policyQualifiers;

        public PolicyInformation(String policyIdentifier) {
            Assert.checkNotNullParam("policyIdentifier", policyIdentifier);
            this.policyIdentifier = policyIdentifier;
            this.policyQualifiers = new ArrayList<PolicyQualifier>();
        }

        @Override
        public void encodeTo(ASN1Encoder encoder) {
            encoder.startSequence();
            encoder.encodeObjectIdentifier(this.policyIdentifier);
            if (!this.policyQualifiers.isEmpty()) {
                encoder.startSequence();
                for (PolicyQualifier policyQualifier : this.policyQualifiers) {
                    policyQualifier.encodeTo(encoder);
                }
                encoder.endSequence();
            }
            encoder.endSequence();
        }
    }
}

