/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import java.util.ArrayList;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.WeldCapability;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.wildfly.extension.microprofile.opentracing.TracingExtensionLogger;
import org.wildfly.microprofile.opentracing.smallrye.TracerInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TracingDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        WeldCapability weldCapability;
        TracingExtensionLogger.ROOT_LOGGER.processingDeployment();
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new DeploymentUnitProcessingException(TracingExtensionLogger.ROOT_LOGGER.deploymentRequiresCapability(deploymentPhaseContext.getDeploymentUnit().getName(), "org.wildfly.weld"));
        }
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
            TracingExtensionLogger.ROOT_LOGGER.noCdiDeployment();
            return;
        }
        this.setServiceName(deploymentUnit);
        this.addListeners(deploymentUnit);
    }

    private void addListeners(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (null == jbossWebMetaData) {
            return;
        }
        TracingExtensionLogger.ROOT_LOGGER.registeringTracerInitializer();
        ListenerMetaData listenerMetaData = new ListenerMetaData();
        listenerMetaData.setListenerClass(TracerInitializer.class.getName());
        ArrayList<ListenerMetaData> listeners = jbossWebMetaData.getListeners();
        if (null == listeners) {
            listeners = new ArrayList<ListenerMetaData>();
        }
        listeners.add(listenerMetaData);
        jbossWebMetaData.setListeners(listeners);
    }

    private void setServiceName(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (null == jbossWebMetaData) {
            return;
        }
        String serviceName = this.getServiceName(deploymentUnit);
        ParamValueMetaData serviceNameContextParameter = new ParamValueMetaData();
        serviceNameContextParameter.setParamName("smallrye.opentracing.serviceName");
        serviceNameContextParameter.setParamValue(serviceName);
        this.addContextParameter(jbossWebMetaData, serviceNameContextParameter);
    }

    private JBossWebMetaData getJBossWebMetaData(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (null == warMetaData) {
            return null;
        }
        return warMetaData.getMergedJBossWebMetaData();
    }

    private void addContextParameter(JBossWebMetaData jbossWebMetaData, ParamValueMetaData restEasyProvider) {
        ArrayList<ParamValueMetaData> contextParams = jbossWebMetaData.getContextParams();
        if (null == contextParams) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        contextParams.add(restEasyProvider);
        jbossWebMetaData.setContextParams(contextParams);
    }

    private String getServiceName(DeploymentUnit deploymentUnit) {
        String serviceName = WildFlySecurityManager.getPropertyPrivileged((String)"JAEGER_SERVICE_NAME", (String)"");
        if (null == serviceName || serviceName.isEmpty()) {
            serviceName = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JAEGER_SERVICE_NAME", (String)"");
        }
        if (null == serviceName || serviceName.isEmpty()) {
            serviceName = null != deploymentUnit.getParent() ? deploymentUnit.getParent().getServiceName().getSimpleName() + "!" + deploymentUnit.getServiceName().getSimpleName() : deploymentUnit.getServiceName().getSimpleName();
            TracingExtensionLogger.ROOT_LOGGER.serviceNameDerivedFromDeploymentUnit(serviceName);
        }
        return serviceName;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

