/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.client.legacy.LegacyPropertiesConfiguration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.common.Assert;

final class ConfigurationBasedEJBClientContextSelector {
    private static final EJBClientContext configuredContext;
    private static final String NS_EJB_CLIENT_3_0 = "urn:jboss:wildfly-client-ejb:3.0";
    private static final String NS_EJB_CLIENT_3_1 = "urn:jboss:wildfly-client-ejb:3.1";
    private static final String NS_INCORRECT = "urn:jboss:ejb-client:3.0";
    private static final Set<String> validNamespaces;

    private ConfigurationBasedEJBClientContextSelector() {
    }

    private static EJBClientContext loadConfiguration() {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        ClassLoader classLoader = ConfigurationBasedEJBClientContextSelector.class.getClassLoader();
        EJBClientContext.Builder builder = new EJBClientContext.Builder();
        ConfigurationBasedEJBClientContextSelector.loadTransportProviders(builder, classLoader);
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(validNamespaces);){
                ConfigurationBasedEJBClientContextSelector.parseEJBClientConfiguration(streamReader, builder);
            }
            catch (ConfigXMLParseException e) {
                throw new IllegalStateException(e);
            }
        }
        LegacyPropertiesConfiguration.configure(builder);
        return builder.build();
    }

    private static void parseEJBClientConfiguration(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        if (streamReader.hasNext()) {
            if (streamReader.nextTag() == 1) {
                String namespaceURI = streamReader.getNamespaceURI();
                if (namespaceURI.equals(NS_INCORRECT)) {
                    throw new ConfigXMLParseException("The namespace \"urn:jboss:ejb-client:3.0\" was incorrect; replace with \"urn:jboss:wildfly-client-ejb:3.1\"", (XMLStreamReader)streamReader);
                }
                if (!validNamespaces.contains(namespaceURI) || !streamReader.getLocalName().equals("jboss-ejb-client")) {
                    throw streamReader.unexpectedElement();
                }
                ConfigurationBasedEJBClientContextSelector.parseEJBClientType(streamReader, builder);
                return;
            }
            throw streamReader.unexpectedContent();
        }
    }

    private static void parseEJBClientType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        int next;
        if (streamReader.getAttributeCount() > 0) {
            throw streamReader.unexpectedAttribute(0);
        }
        boolean gotInvocationTimeout = false;
        boolean gotGlobalInterceptors = false;
        boolean gotConnections = false;
        boolean gotClusterNodeSelector = false;
        boolean gotDeploymentNodeSelector = false;
        while ((next = streamReader.nextTag()) == 1) {
            String configuredNamespace = streamReader.getNamespaceURI();
            if (!validNamespaces.contains(configuredNamespace)) {
                throw streamReader.unexpectedElement();
            }
            String localName = streamReader.getLocalName();
            if (localName.equals("invocation-timeout") && !gotInvocationTimeout && ConfigurationBasedEJBClientContextSelector.inValidNamespace(validNamespaces, configuredNamespace)) {
                gotInvocationTimeout = true;
                ConfigurationBasedEJBClientContextSelector.parseInvocationTimeoutType(streamReader, builder);
                continue;
            }
            if (localName.equals("global-interceptors") && !gotGlobalInterceptors && ConfigurationBasedEJBClientContextSelector.inValidNamespace(validNamespaces, configuredNamespace)) {
                gotGlobalInterceptors = true;
                ConfigurationBasedEJBClientContextSelector.parseInterceptorsType(streamReader, builder);
                continue;
            }
            if (localName.equals("connections") && !gotConnections && ConfigurationBasedEJBClientContextSelector.inValidNamespace(validNamespaces, configuredNamespace)) {
                gotConnections = true;
                ConfigurationBasedEJBClientContextSelector.parseConnectionsType(streamReader, builder);
                continue;
            }
            if (localName.equals("deployment-node-selector") && !gotDeploymentNodeSelector && ConfigurationBasedEJBClientContextSelector.inValidNamespace(Collections.singleton(NS_EJB_CLIENT_3_1), configuredNamespace)) {
                gotDeploymentNodeSelector = true;
                ConfigurationBasedEJBClientContextSelector.parseDeploymentNodeSelectorType(streamReader, builder);
                continue;
            }
            if (localName.equals("cluster-node-selector") && !gotClusterNodeSelector && ConfigurationBasedEJBClientContextSelector.inValidNamespace(Collections.singleton(NS_EJB_CLIENT_3_1), configuredNamespace)) {
                gotClusterNodeSelector = true;
                ConfigurationBasedEJBClientContextSelector.parseClusterNodeSelectorType(streamReader, builder);
                continue;
            }
            throw streamReader.unexpectedElement();
        }
        if (next == 2) {
            return;
        }
        throw Assert.unreachableCode();
    }

    private static boolean inValidNamespace(Set<String> validNamespaces, String configuredNamespace) {
        return validNamespaces.contains(configuredNamespace);
    }

    private static void parseInvocationTimeoutType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        int attributeCount = streamReader.getAttributeCount();
        int timeout = -1;
        for (int i = 0; i < attributeCount; ++i) {
            if (streamReader.getAttributeNamespace(i) != null && !streamReader.getAttributeNamespace(i).isEmpty()) {
                throw streamReader.unexpectedAttribute(i);
            }
            String name = streamReader.getAttributeLocalName(i);
            if (!name.equals("seconds")) {
                throw streamReader.unexpectedAttribute(i);
            }
            timeout = streamReader.getIntAttributeValueResolved(i);
            long timeoutInMs = timeout == -1 ? (long)timeout : (long)(timeout * 1000);
            builder.setInvocationTimeout(timeoutInMs);
        }
        int next = streamReader.nextTag();
        if (next == 2) {
            return;
        }
        throw streamReader.unexpectedElement();
    }

    private static void parseInterceptorsType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        int next;
        if (streamReader.getAttributeCount() > 0) {
            throw streamReader.unexpectedAttribute(0);
        }
        while ((next = streamReader.nextTag()) == 1) {
            if (!streamReader.getNamespaceURI().equals(NS_EJB_CLIENT_3_0) || !streamReader.getLocalName().equals("interceptor")) {
                throw streamReader.unexpectedElement();
            }
            ConfigurationBasedEJBClientContextSelector.parseInterceptorType(streamReader, builder);
        }
        if (next == 2) {
            return;
        }
        throw Assert.unreachableCode();
    }

    private static void parseInterceptorType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        Class<EJBClientInterceptor> interceptorClass = ConfigurationBasedEJBClientContextSelector.parseClassType(streamReader, EJBClientInterceptor.class);
        builder.addInterceptor(interceptorClass);
    }

    private static void parseClusterNodeSelectorType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        Class<ClusterNodeSelector> clusterNodeSelectorClass = ConfigurationBasedEJBClientContextSelector.parseClassType(streamReader, ClusterNodeSelector.class);
        try {
            builder.setClusterNodeSelector(clusterNodeSelectorClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigXMLParseException(e);
        }
    }

    private static void parseDeploymentNodeSelectorType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        Class<DeploymentNodeSelector> deploymentNodeSelectorClass = ConfigurationBasedEJBClientContextSelector.parseClassType(streamReader, DeploymentNodeSelector.class);
        try {
            builder.setDeploymentNodeSelector(deploymentNodeSelectorClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigXMLParseException(e);
        }
    }

    private static <T> Class<? extends T> parseClassType(ConfigurationXMLStreamReader streamReader, Class<T> interfaceToImplement) throws ConfigXMLParseException {
        Class<T> clazz;
        ClassLoader cl;
        int attributeCount = streamReader.getAttributeCount();
        String className = null;
        String moduleName = null;
        for (int i = 0; i < attributeCount; ++i) {
            if (streamReader.getAttributeNamespace(i) != null && !streamReader.getAttributeNamespace(i).isEmpty()) {
                throw streamReader.unexpectedAttribute(i);
            }
            String name = streamReader.getAttributeLocalName(i);
            if (name.equals("class")) {
                className = streamReader.getAttributeValueResolved(i);
                continue;
            }
            if (name.equals("moduleName")) {
                moduleName = streamReader.getAttributeValueResolved(i);
                continue;
            }
            throw streamReader.unexpectedAttribute(i);
        }
        if (className == null) {
            throw streamReader.missingRequiredAttribute(null, "class");
        }
        if (moduleName != null) {
            try {
                cl = ModuleLoadDelegate.loadModule(moduleName);
            }
            catch (LinkageError e) {
                throw Logs.MAIN.noJBossModules(streamReader);
            }
        } else {
            cl = ConfigurationBasedEJBClientContextSelector.class.getClassLoader();
        }
        try {
            clazz = Class.forName(className, false, cl).asSubclass(interfaceToImplement);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new ConfigXMLParseException(e);
        }
        int next = streamReader.nextTag();
        if (next == 2) {
            return clazz;
        }
        throw streamReader.unexpectedElement();
    }

    private static void parseConnectionsType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        int next;
        if (streamReader.getAttributeCount() > 0) {
            throw streamReader.unexpectedAttribute(0);
        }
        while ((next = streamReader.nextTag()) == 1) {
            if (!streamReader.getNamespaceURI().equals(NS_EJB_CLIENT_3_0)) {
                throw streamReader.unexpectedElement();
            }
            String localName = streamReader.getLocalName();
            if (localName.equals("connection")) {
                ConfigurationBasedEJBClientContextSelector.parseConnectionType(streamReader, builder);
                continue;
            }
            throw streamReader.unexpectedElement();
        }
        if (next == 2) {
            return;
        }
        throw Assert.unreachableCode();
    }

    private static void parseConnectionType(ConfigurationXMLStreamReader streamReader, EJBClientContext.Builder builder) throws ConfigXMLParseException {
        URI uri = null;
        int attributeCount = streamReader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            if (streamReader.getAttributeNamespace(i) != null && !streamReader.getAttributeNamespace(i).isEmpty() || !streamReader.getAttributeLocalName(i).equals("uri") || uri != null) {
                throw streamReader.unexpectedAttribute(i);
            }
            uri = streamReader.getURIAttributeValueResolved(i);
        }
        if (uri == null) {
            throw streamReader.missingRequiredAttribute(null, "uri");
        }
        int next = streamReader.nextTag();
        if (next == 1) {
            if (!streamReader.getNamespaceURI().equals(NS_EJB_CLIENT_3_0)) {
                throw streamReader.unexpectedElement();
            }
            String localName = streamReader.getLocalName();
            if (localName.equals("interceptors")) {
                streamReader.skipContent();
            }
        } else {
            if (next == 2) {
                EJBClientConnection.Builder connBuilder = new EJBClientConnection.Builder();
                connBuilder.setDestination(uri);
                builder.addClientConnection(connBuilder.build());
                return;
            }
            throw Assert.unreachableCode();
        }
    }

    private static void loadTransportProviders(EJBClientContext.Builder builder, ClassLoader classLoader) {
        ServiceLoader<EJBTransportProvider> serviceLoader = ServiceLoader.load(EJBTransportProvider.class, classLoader);
        Iterator<EJBTransportProvider> iterator = serviceLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    EJBTransportProvider transportProvider = iterator.next();
                    builder.addTransportProvider(transportProvider);
                }
            }
            catch (ServiceConfigurationError ignored) {
                Logs.MAIN.error("Failed to load service", ignored);
                continue;
            }
            break;
        }
    }

    static EJBClientContext get() {
        return configuredContext;
    }

    static {
        validNamespaces = new HashSet<String>(Arrays.asList(NS_EJB_CLIENT_3_0, NS_EJB_CLIENT_3_1));
        configuredContext = ConfigurationBasedEJBClientContextSelector.loadConfiguration();
    }

    static final class ModuleLoadDelegate {
        ModuleLoadDelegate() {
        }

        static ClassLoader loadModule(String moduleName) throws ConfigXMLParseException {
            try {
                return Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)moduleName)).getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw new ConfigXMLParseException(e);
            }
        }
    }
}

