/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.wildfly.clustering.web.cache.session.FilteringHttpSession;
import org.wildfly.clustering.web.cache.session.ImmutableFilteringHttpSession;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionActivationNotifier
implements SessionActivationNotifier {
    private final FilteringHttpSession session;

    public ImmutableSessionActivationNotifier(ImmutableSession session, ServletContext context) {
        this.session = new ImmutableFilteringHttpSession(session, context);
    }

    @Override
    public void prePassivate() {
        Map<String, HttpSessionActivationListener> listeners = this.session.getAttributes(HttpSessionActivationListener.class);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this.session);
            for (HttpSessionActivationListener listener : listeners.values()) {
                listener.sessionWillPassivate(event);
            }
        }
    }

    @Override
    public void postActivate() {
        Map<String, HttpSessionActivationListener> listeners = this.session.getAttributes(HttpSessionActivationListener.class);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this.session);
            for (HttpSessionActivationListener listener : listeners.values()) {
                listener.sessionDidActivate(event);
            }
        }
    }
}

