/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.time;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;

public class DefaultTimeService
implements TimeService {
    public static final DefaultTimeService INSTANCE = new DefaultTimeService();
    private final Clock clock = Clock.systemUTC();

    @Override
    public long wallClockTime() {
        return System.currentTimeMillis();
    }

    @Override
    public long time() {
        return System.nanoTime();
    }

    @Override
    public Instant instant() {
        return this.clock.instant();
    }

    @Override
    public long timeDuration(long startTime, TimeUnit outputTimeUnit) {
        return this.timeDuration(startTime, this.time(), outputTimeUnit);
    }

    @Override
    public long timeDuration(long startTime, long endTime, TimeUnit outputTimeUnit) {
        long remaining = endTime - startTime;
        if (remaining <= 0L) {
            return 0L;
        }
        return outputTimeUnit.convert(remaining, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isTimeExpired(long endTime) {
        return this.time() - endTime >= 0L;
    }

    @Override
    public long remainingTime(long endTime, TimeUnit outputTimeUnit) {
        long remaining = endTime - this.time();
        return remaining <= 0L ? 0L : outputTimeUnit.convert(remaining, TimeUnit.NANOSECONDS);
    }

    @Override
    public long expectedEndTime(long duration, TimeUnit inputTimeUnit) {
        if (duration <= 0L) {
            return this.time();
        }
        return this.time() + inputTimeUnit.toNanos(duration);
    }
}

