/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.enterprise.concurrent.ManageableThread;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;

public class ManagedExecutors {
    private ManagedExecutors() {
    }

    public static boolean isCurrentThreadShutdown() {
        Thread thread = Thread.currentThread();
        return thread instanceof ManageableThread && ((ManageableThread)((Object)thread)).isShutdown();
    }

    public static <V> Callable<V> managedTask(Callable<V> task, ManagedTaskListener taskListener) throws IllegalArgumentException {
        return new ManagedCallable<V>(task, taskListener, null);
    }

    public static <V> Callable<V> managedTask(Callable<V> task, Map<String, String> executionProperties, ManagedTaskListener taskListener) throws IllegalArgumentException {
        return new ManagedCallable<V>(task, taskListener, executionProperties);
    }

    public static Runnable managedTask(Runnable task, ManagedTaskListener taskListener) throws IllegalArgumentException {
        return new ManagedRunnable(task, taskListener, null);
    }

    public static Runnable managedTask(Runnable task, Map<String, String> executionProperties, ManagedTaskListener taskListener) throws IllegalArgumentException {
        return new ManagedRunnable(task, taskListener, executionProperties);
    }

    static abstract class AbstractManagedTask
    implements ManagedTask {
        private ManagedTaskListener taskListener;
        private Map<String, String> executionProperties = null;

        AbstractManagedTask(Object task, ManagedTaskListener taskListener, Map<String, String> executionProperties) throws IllegalArgumentException {
            ManagedTask managedTask;
            if (task == null) {
                throw new IllegalArgumentException("null task");
            }
            ManagedTask managedTask2 = managedTask = task instanceof ManagedTask ? (ManagedTask)task : null;
            if (taskListener != null) {
                this.taskListener = taskListener;
            } else {
                ManagedTaskListener managedTaskListener = this.taskListener = managedTask != null ? managedTask.getManagedTaskListener() : null;
            }
            if (managedTask != null && managedTask.getExecutionProperties() != null) {
                this.executionProperties = new HashMap<String, String>(managedTask.getExecutionProperties());
            }
            if (executionProperties != null) {
                if (this.executionProperties == null) {
                    this.executionProperties = new HashMap<String, String>(executionProperties);
                } else {
                    this.executionProperties.putAll(executionProperties);
                }
            }
        }

        @Override
        public Map<String, String> getExecutionProperties() {
            return this.executionProperties;
        }

        @Override
        public ManagedTaskListener getManagedTaskListener() {
            return this.taskListener;
        }
    }

    static class ManagedRunnable
    extends AbstractManagedTask
    implements Runnable {
        private Runnable task;

        ManagedRunnable(Runnable task, ManagedTaskListener taskListener, Map<String, String> executionProperties) {
            super(task, taskListener, executionProperties);
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    static class ManagedCallable<V>
    extends AbstractManagedTask
    implements Callable<V> {
        private Callable<V> task;

        ManagedCallable(Callable<V> task, ManagedTaskListener taskListener, Map<String, String> executionProperties) {
            super(task, taskListener, executionProperties);
            this.task = task;
        }

        @Override
        public V call() throws Exception {
            return this.task.call();
        }
    }
}

