/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.services.bootstrap.WeldSecurityServices;
import org.jboss.as.weld.spi.BootstrapDependencyInstaller;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SecurityBootstrapDependencyInstaller
implements BootstrapDependencyInstaller {
    public ServiceName install(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, boolean jtsEnabled) {
        ServiceName serviceName = deploymentUnit.getServiceName().append(WeldSecurityServices.SERVICE_NAME);
        CapabilityServiceSupport capabilities = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceBuilder sb = serviceTarget.addService(serviceName);
        Consumer securityServicesConsumer = sb.provides(new ServiceName[]{serviceName});
        Supplier securityManagerSupplier = null;
        if (capabilities.hasCapability("org.wildfly.legacy-security.server-security-manager")) {
            securityManagerSupplier = sb.requires(capabilities.getCapabilityServiceName("org.wildfly.legacy-security.server-security-manager"));
        }
        sb.setInstance((Service)new WeldSecurityServices(securityServicesConsumer, securityManagerSupplier));
        sb.install();
        return serviceName;
    }
}

