/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public class PrometheusCollector
extends Collector
implements Collector.Describable {
    private Map<String, Collector.MetricFamilySamples> metricNames = new TreeMap<String, Collector.MetricFamilySamples>();
    private Map<String, List<Supplier<Optional<Collector.MetricFamilySamples.Sample>>>> metricFamilyMap = new HashMap<String, List<Supplier<Optional<Collector.MetricFamilySamples.Sample>>>>();

    public synchronized void addMetricFamilySamples(Collector.MetricFamilySamples mfs) {
        if (!this.metricNames.containsKey(mfs.name)) {
            this.metricNames.put(mfs.name, mfs);
            this.metricFamilyMap.put(mfs.name, new CopyOnWriteArrayList());
        }
    }

    void addMetricFamilySampleSupplier(Collector.MetricFamilySamples mfs, Supplier<Optional<Collector.MetricFamilySamples.Sample>> sampleSupplier) {
        this.addMetricFamilySamples(mfs);
        this.metricFamilyMap.get(mfs.name).add(sampleSupplier);
    }

    void removeMetricFamilySampleSupplier(String metricName, Supplier<Optional<Collector.MetricFamilySamples.Sample>> sampleSupplier) {
        List<Supplier<Optional<Collector.MetricFamilySamples.Sample>>> suppliers = this.metricFamilyMap.get(metricName);
        if (suppliers != null) {
            suppliers.remove(sampleSupplier);
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>();
        for (Map.Entry<String, List<Supplier<Optional<Collector.MetricFamilySamples.Sample>>>> entry : this.metricFamilyMap.entrySet()) {
            String metricName = entry.getKey();
            Collector.MetricFamilySamples mfs = this.metricNames.get(metricName);
            mfs.samples.clear();
            for (Supplier<Optional<Collector.MetricFamilySamples.Sample>> sampleSupplier : entry.getValue()) {
                Optional<Collector.MetricFamilySamples.Sample> sample = sampleSupplier.get();
                if (!sample.isPresent()) continue;
                mfs.samples.add(sample.get());
            }
            if (mfs.samples.isEmpty()) continue;
            samples.add(mfs);
        }
        return samples;
    }

    public List<Collector.MetricFamilySamples> describe() {
        return new ArrayList<Collector.MetricFamilySamples>(this.metricNames.values());
    }
}

