/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.SseEventSource;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl;
import org.jboss.resteasy.rxjava2.ObservableRxInvoker;
import org.jboss.resteasy.rxjava2.i18n.Messages;

public class ObservableRxInvokerImpl
implements ObservableRxInvoker {
    private static Object monitor = new Object();
    private ClientInvocationBuilder syncInvoker;
    private ScheduledExecutorService executorService;

    public ObservableRxInvokerImpl(SyncInvoker syncInvoker, ExecutorService executorService) {
        if (!(syncInvoker instanceof ClientInvocationBuilder)) {
            throw new ProcessingException(Messages.MESSAGES.expectedClientInvocationBuilder(syncInvoker.getClass().getName()));
        }
        this.syncInvoker = (ClientInvocationBuilder)syncInvoker;
        if (executorService instanceof ScheduledExecutorService) {
            this.executorService = (ScheduledExecutorService)executorService;
        }
    }

    public Observable<?> get() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "GET", null, this.getAccept());
    }

    public <R> Observable<?> get(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public <R> Observable<?> get(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public Observable<?> put(Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "PUT", entity, this.getAccept());
    }

    public <R> Observable<?> put(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public <R> Observable<?> put(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public Observable<?> post(Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "POST", entity, this.getAccept());
    }

    public <R> Observable<?> post(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public <R> Observable<?> post(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public Observable<?> delete() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "DELETE", null, this.getAccept());
    }

    public <R> Observable<?> delete(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public <R> Observable<?> delete(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public Observable<?> head() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "HEAD", null, this.getAccept());
    }

    public Observable<?> options() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "OPTIONS", null, this.getAccept());
    }

    public <R> Observable<?> options(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public <R> Observable<?> options(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public Observable<?> trace() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "TRACE", null, this.getAccept());
    }

    public <R> Observable<?> trace(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public <R> Observable<?> trace(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public Observable<?> method(String name) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, name, null, this.getAccept());
    }

    public <R> Observable<?> method(String name, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public <R> Observable<?> method(String name, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public Observable<?> method(String name, Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, name, entity, this.getAccept());
    }

    public <R> Observable<?> method(String name, Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    public <R> Observable<?> method(String name, Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    private <T> Observable<T> eventSourceToObservable(final SseEventSourceImpl sseEventSource, final Class<T> clazz, final String verb, final Entity<?> entity, final MediaType[] mediaTypes) {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                sseEventSource.register(e -> {
                    Object t = e.readData(clazz, ((InboundSseEventImpl)e).getMediaType());
                    emitter.onNext(t);
                }, t -> emitter.onError(t), () -> emitter.onComplete());
                Object object = monitor;
                synchronized (object) {
                    if (!sseEventSource.isOpen()) {
                        sseEventSource.open(null, verb, entity, mediaTypes);
                    }
                }
            }
        });
        return observable;
    }

    private <T> Observable<T> eventSourceToObservable(final SseEventSourceImpl sseEventSource, final GenericType<T> type, final String verb, final Entity<?> entity, final MediaType[] mediaTypes) {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                sseEventSource.register(e -> {
                    Object t = e.readData(type, ((InboundSseEventImpl)e).getMediaType());
                    emitter.onNext(t);
                }, t -> emitter.onError(t), () -> emitter.onComplete());
                Object object = monitor;
                synchronized (object) {
                    if (!sseEventSource.isOpen()) {
                        sseEventSource.open(null, verb, entity, mediaTypes);
                    }
                }
            }
        });
        return observable;
    }

    private SseEventSourceImpl getEventSource() {
        SseEventSourceImpl.SourceBuilder builder = (SseEventSourceImpl.SourceBuilder)SseEventSource.target((WebTarget)this.syncInvoker.getTarget());
        if (this.executorService != null) {
            builder.executor(this.executorService);
        }
        SseEventSourceImpl sseEventSource = (SseEventSourceImpl)builder.build();
        sseEventSource.setAlwaysReconnect(false);
        return sseEventSource;
    }

    private MediaType[] getAccept() {
        if (this.syncInvoker instanceof ClientInvocationBuilder) {
            ClientInvocationBuilder builder = this.syncInvoker;
            List accept = builder.getHeaders().getAcceptableMediaTypes();
            return accept.toArray(new MediaType[accept.size()]);
        }
        return null;
    }
}

