/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

@Listener(sync=false)
public class FineSessionAttributesFactory<V>
implements SessionAttributesFactory<Map<String, UUID>>,
BiFunction<SessionAttributeKey, V, Mutator> {
    private final Cache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final Cache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;

    public FineSessionAttributesFactory(Cache<SessionAttributeNamesKey, Map<String, UUID>> namesCache, Cache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller, Immutability immutability, CacheProperties properties) {
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.immutability = immutability;
        this.properties = properties;
    }

    @Override
    public Mutator apply(SessionAttributeKey key, V value) {
        return new CacheEntryMutator(this.attributeCache, (Object)key, value);
    }

    public Map<String, UUID> createValue(String id, Void context) {
        return Collections.emptyMap();
    }

    public Map<String, UUID> findValue(String id) {
        Map names = (Map)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            for (Map.Entry nameEntry : names.entrySet()) {
                Object value = this.attributeCache.get((Object)new SessionAttributeKey(id, (UUID)nameEntry.getValue()));
                if (value != null) {
                    try {
                        this.marshaller.read(value);
                        continue;
                    }
                    catch (InvalidSerializedFormException e) {
                        InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)nameEntry.getKey());
                    }
                } else {
                    InfinispanWebLogger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)nameEntry.getKey());
                }
                this.remove(id);
                return null;
            }
            return names;
        }
        return Collections.emptyMap();
    }

    public boolean remove(String id) {
        Map names = (Map)this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            for (UUID attributeId : names.values()) {
                this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributeKey(id, attributeId));
            }
        }
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, UUID> names) {
        return new FineSessionAttributes((Object)new SessionAttributeNamesKey(id), names, this.namesCache, FineSessionAttributesFactory.getKeyFactory(id), (Map)this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}), this.marshaller, (BiFunction)this, this.immutability, this.properties);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map<String, UUID> names) {
        return new FineImmutableSessionAttributes(names, FineSessionAttributesFactory.getKeyFactory(id), this.attributeCache, this.marshaller);
    }

    private static Function<UUID, SessionAttributeKey> getKeyFactory(final String id) {
        return new Function<UUID, SessionAttributeKey>(){

            @Override
            public SessionAttributeKey apply(UUID attributeId) {
                return new SessionAttributeKey(id, attributeId);
            }
        };
    }

    @CacheEntriesEvicted
    public void evicted(CacheEntriesEvictedEvent<Key<String>, ?> event) {
        if (!event.isPre()) {
            HashSet<SessionAttributeNamesKey> keys = new HashSet<SessionAttributeNamesKey>();
            for (Key key : event.getEntries().keySet()) {
                if (!(key instanceof SessionCreationMetaDataKey)) continue;
                keys.add(new SessionAttributeNamesKey((String)key.getValue()));
            }
            if (!keys.isEmpty()) {
                AdvancedCache cache = this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
                for (Map.Entry entry : this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).getAll(keys).entrySet()) {
                    Map names = (Map)entry.getValue();
                    if (names != null) {
                        String sessionId = (String)((SessionAttributeNamesKey)((Object)entry.getKey())).getValue();
                        for (UUID attributeId : names.values()) {
                            cache.evict((Object)new SessionAttributeKey(sessionId, attributeId));
                        }
                    }
                    this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).evict(entry.getKey());
                }
            }
        }
    }
}

