/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.util.function.Supplier;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.CacheException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class TransactionHelper {
    private static final Log log = LogFactory.getLog(FineGrainedAtomicMap.class);
    private static final boolean trace = log.isTraceEnabled();
    private final TransactionManager transactionManager;
    private final BatchContainer batchContainer;
    private final boolean autoCommit;

    public TransactionHelper(AdvancedCache<?, ?> cache) {
        this.transactionManager = cache.getTransactionManager();
        if (this.transactionManager == null) {
            throw log.atomicFineGrainedNeedsTransactions();
        }
        this.batchContainer = cache.getCacheConfiguration().invocationBatching().enabled() ? cache.getBatchContainer() : null;
        this.autoCommit = cache.getCacheConfiguration().transaction().autoCommit();
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null && this.batchContainer != null) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    <T> T run(Supplier<T> op) {
        Transaction transaction = this.getOngoingTransaction();
        if (transaction != null) {
            return op.get();
        }
        if (!this.autoCommit) {
            throw log.atomicFineGrainedNeedsExplicitTxOrAutoCommit();
        }
        try {
            this.transactionManager.begin();
        }
        catch (Throwable t) {
            throw new CacheException("Unable to begin implicit transaction.", t);
        }
        Throwable operationException = null;
        try {
            T t = op.get();
            return t;
        }
        catch (Throwable t) {
            try {
                this.transactionManager.setRollbackOnly();
            }
            catch (Throwable t1) {
                t1.addSuppressed(t);
                operationException = t1;
                throw new CacheException("Unable to rollback implicit transaction.", t1);
            }
            operationException = t;
            throw t;
        }
        finally {
            try {
                if (this.transactionManager.getStatus() == 0) {
                    this.transactionManager.commit();
                } else {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable e) {
                if (operationException != null) {
                    e.addSuppressed(operationException);
                }
                log.couldNotCompleteInjectedTransaction(e);
                throw new CacheException(e);
            }
        }
    }
}

