/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.remoting.inboundhandler.NonTotalOrderPerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.NonTotalOrderTxPerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.TotalOrderTxPerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.TrianglePerCacheInboundInvocationHandler;

@DefaultFactoryFor(classes={PerCacheInboundInvocationHandler.class})
public class InboundInvocationHandlerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            return null;
        }
        if (this.configuration.transaction().transactionMode().isTransactional()) {
            return this.configuration.transaction().transactionProtocol().isTotalOrder() ? new TotalOrderTxPerCacheInboundInvocationHandler() : new NonTotalOrderTxPerCacheInboundInvocationHandler();
        }
        if (this.configuration.clustering().cacheMode().isDistributed() && Configurations.isEmbeddedMode(this.globalConfiguration) || this.configuration.clustering().cacheMode().isScattered() && this.configuration.clustering().biasAcquisition() != BiasAcquisition.NEVER) {
            return new TrianglePerCacheInboundInvocationHandler();
        }
        return new NonTotalOrderPerCacheInboundInvocationHandler();
    }
}

