/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class FactoryConfig
extends ValueConfig {
    private static final long serialVersionUID = 1L;
    private String bean;
    private BeanState state;
    protected final transient InjectedValue<BeanInfo> beanInfo = new InjectedValue();
    protected final transient InjectedValue<Object> value = new InjectedValue();

    @Override
    protected Object getClassValue(Class<?> type) {
        return this.value.getValue();
    }

    @Override
    public void visit(ConfigVisitor visitor) {
        if (this.bean != null) {
            visitor.addDependency(this.bean, BeanState.DESCRIBED, (Injector)this.beanInfo);
            ServiceName name = BeanMetaDataConfig.toBeanName(this.bean, this.state);
            visitor.addDependency(name, (Injector)this.value);
        }
        super.visit(visitor);
    }

    @Override
    public Class<?> getType(ConfigVisitor visitor, ConfigVisitorNode previous) {
        throw PojoLogger.ROOT_LOGGER.tooDynamicFromFactory();
    }

    public void setBean(String dependency) {
        this.bean = dependency;
    }

    public void setState(BeanState state) {
        this.state = state;
    }

    public BeanInfo getBeanInfo() {
        return (BeanInfo)this.beanInfo.getValue();
    }
}

