/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

final class SegmentCoreReaders {
    private final AtomicInteger ref = new AtomicInteger(1);
    final FieldsProducer fields;
    final NormsProducer normsProducer;
    final StoredFieldsReader fieldsReaderOrig;
    final TermVectorsReader termVectorsReaderOrig;
    final Directory cfsReader;
    final FieldInfos coreFieldInfos;
    final CloseableThreadLocal<StoredFieldsReader> fieldsReaderLocal = new CloseableThreadLocal<StoredFieldsReader>(){

        @Override
        protected StoredFieldsReader initialValue() {
            return SegmentCoreReaders.this.fieldsReaderOrig.clone();
        }
    };
    final CloseableThreadLocal<TermVectorsReader> termVectorsLocal = new CloseableThreadLocal<TermVectorsReader>(){

        @Override
        protected TermVectorsReader initialValue() {
            return SegmentCoreReaders.this.termVectorsReaderOrig == null ? null : SegmentCoreReaders.this.termVectorsReaderOrig.clone();
        }
    };
    private final Set<LeafReader.CoreClosedListener> coreClosedListeners = Collections.synchronizedSet(new LinkedHashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentCoreReaders(SegmentReader owner, Directory dir, SegmentCommitInfo si, IOContext context) throws IOException {
        Codec codec = si.info.getCodec();
        boolean success = false;
        try {
            Directory cfsDir;
            if (si.info.getUseCompoundFile()) {
                cfsDir = this.cfsReader = codec.compoundFormat().getCompoundReader(dir, si.info, context);
            } else {
                this.cfsReader = null;
                cfsDir = dir;
            }
            this.coreFieldInfos = codec.fieldInfosFormat().read(cfsDir, si.info, "", context);
            SegmentReadState segmentReadState = new SegmentReadState(cfsDir, si.info, this.coreFieldInfos, context);
            PostingsFormat format = codec.postingsFormat();
            this.fields = format.fieldsProducer(segmentReadState);
            assert (this.fields != null);
            if (this.coreFieldInfos.hasNorms()) {
                this.normsProducer = codec.normsFormat().normsProducer(segmentReadState);
                assert (this.normsProducer != null);
            } else {
                this.normsProducer = null;
            }
            this.fieldsReaderOrig = si.info.getCodec().storedFieldsFormat().fieldsReader(cfsDir, si.info, this.coreFieldInfos, context);
            this.termVectorsReaderOrig = this.coreFieldInfos.hasVectors() ? si.info.getCodec().termVectorsFormat().vectorsReader(cfsDir, si.info, this.coreFieldInfos, context) : null;
            success = true;
        }
        finally {
            if (!success) {
                this.decRef();
            }
        }
    }

    int getRefCount() {
        return this.ref.get();
    }

    void incRef() {
        int count;
        while ((count = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(count, count + 1)) continue;
            return;
        }
        throw new AlreadyClosedException("SegmentCoreReaders is already closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            Throwable th = null;
            try {
                IOUtils.close(this.termVectorsLocal, this.fieldsReaderLocal, this.fields, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.normsProducer);
            }
            catch (Throwable throwable) {
                th = throwable;
            }
            finally {
                this.notifyCoreClosedListeners(th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCoreClosedListeners(Throwable th) {
        Set<LeafReader.CoreClosedListener> set = this.coreClosedListeners;
        synchronized (set) {
            for (LeafReader.CoreClosedListener listener : this.coreClosedListeners) {
                try {
                    listener.onClose(this);
                }
                catch (Throwable t) {
                    if (th == null) {
                        th = t;
                        continue;
                    }
                    th.addSuppressed(t);
                }
            }
            IOUtils.reThrowUnchecked(th);
        }
    }

    void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
        this.coreClosedListeners.add(listener);
    }

    void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
        this.coreClosedListeners.remove(listener);
    }
}

