/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.clustering.controller.ReloadRequiredResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.LegacyMetricOperationsRegistration;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterModel;
import org.wildfly.extension.mod_cluster.ProxyOperation;
import org.wildfly.extension.mod_cluster.ProxyOperationExecutor;
import org.wildfly.extension.mod_cluster.SSLResourceDefinition;
import org.wildfly.extension.mod_cluster.SimpleLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.ZeroToNegativeOneParameterCorrector;

public class ProxyConfigurationResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    private static final String UNDERTOW_LISTENER_CAPABILITY_NAME = "org.wildfly.undertow.listener";
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"mod-cluster-config", (String)"configuration");
    static final PathElement WILDCARD_PATH = ProxyConfigurationResourceDefinition.pathElement("*");
    private static final AttributeTranslation SIMPLE_LOAD_PROVIDER_TRANSLATION = new AttributeTranslation(){
        private final AttributeValueTranslator simpleLoadFactorDefinedValidator = new AttributeValueTranslator(){

            public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                PathAddress currentAddress = context.getCurrentAddress();
                if (currentAddress.getLastElement().equals(SimpleLoadProviderResourceDefinition.PATH)) {
                    return value;
                }
                try {
                    PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{DynamicLoadProviderResourceDefinition.PATH});
                    context.readResource(address, false);
                }
                catch (Resource.NoSuchResourceException ignore) {
                    return value;
                }
                throw ModClusterLogger.ROOT_LOGGER.simpleLoadFactorProviderIsNotConfigured();
            }
        };

        public org.jboss.as.clustering.controller.Attribute getTargetAttribute() {
            return SimpleLoadProviderResourceDefinition.Attribute.FACTOR;
        }

        public AttributeValueTranslator getReadTranslator() {
            return this.simpleLoadFactorDefinedValidator;
        }

        public AttributeValueTranslator getWriteTranslator() {
            return this.simpleLoadFactorDefinedValidator;
        }

        public UnaryOperator<PathAddress> getPathAddressTransformation() {
            return new UnaryOperator<PathAddress>(){

                @Override
                public PathAddress apply(PathAddress pathAddress) {
                    return pathAddress.append(new PathElement[]{SimpleLoadProviderResourceDefinition.PATH});
                }
            };
        }
    };

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"proxy", (String)name);
    }

    public ProxyConfigurationResourceDefinition() {
        super(WILDCARD_PATH, ModClusterExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH}));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(EnumSet.complementOf(EnumSet.of(Attribute.SSL_CONTEXT))).addExtraParameters(new org.jboss.as.clustering.controller.Attribute[]{Attribute.SSL_CONTEXT}).addAttributeTranslation((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.SIMPLE_LOAD_PROVIDER, SIMPLE_LOAD_PROVIDER_TRANSLATION).addAlias((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.CONNECTOR, (org.jboss.as.clustering.controller.Attribute)Attribute.LISTENER).addRequiredSingletonChildren(new PathElement[]{SimpleLoadProviderResourceDefinition.PATH}).addCapabilities(Capability.class);
        registration.registerReadWriteAttribute(Attribute.SSL_CONTEXT.getDefinition(), null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[0]){

            protected void validateUpdatedModel(OperationContext context, final Resource model) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext ctx, ModelNode op) throws OperationFailedException {
                        if (model.hasChild(SSLResourceDefinition.PATH)) {
                            throw new OperationFailedException((Throwable)ModClusterLogger.ROOT_LOGGER.bothElytronAndLegacySslContextDefined());
                        }
                    }
                }, OperationContext.Stage.MODEL);
            }
        });
        parent.registerAlias(LEGACY_PATH, new AliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration){

            public PathAddress convertToTargetAddress(PathAddress aliasAddress, AliasEntry.AliasContext aliasContext) {
                PathAddress rebuiltAddress = PathAddress.EMPTY_ADDRESS;
                for (PathElement pathElement : aliasAddress) {
                    if (pathElement.equals(LEGACY_PATH)) {
                        try {
                            if (aliasContext.readResourceFromRoot(rebuiltAddress, false).hasChildren(WILDCARD_PATH.getKey())) {
                                Set children = aliasContext.readResourceFromRoot(rebuiltAddress, false).getChildren(WILDCARD_PATH.getKey());
                                if (children.size() > 1 && !Operations.getOperationName((ModelNode)aliasContext.getOperation()).equals("recursive-global-op")) {
                                    throw new IllegalStateException(ModClusterLogger.ROOT_LOGGER.legacyOperationsWithMultipleProxies());
                                }
                                PathAddress proxyPath = PathAddress.pathAddress((PathElement[])new PathElement[]{ProxyConfigurationResourceDefinition.pathElement(((Resource.ResourceEntry)children.iterator().next()).getName())});
                                rebuiltAddress = rebuiltAddress.append(proxyPath);
                                continue;
                            }
                            rebuiltAddress = rebuiltAddress.append(new PathElement[]{ProxyConfigurationResourceDefinition.pathElement("default")});
                        }
                        catch (Resource.NoSuchResourceException ignore) {
                            rebuiltAddress = rebuiltAddress.append(new PathElement[]{WILDCARD_PATH});
                        }
                        continue;
                    }
                    rebuiltAddress = rebuiltAddress.append(new PathElement[]{pathElement});
                }
                return rebuiltAddress;
            }
        });
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new OperationHandler((OperationExecutor)new ProxyOperationExecutor(), ProxyOperation.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new ReloadRequiredResourceRegistration((AddStepHandlerDescriptor)descriptor).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new LegacyMetricOperationsRegistration().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new SimpleLoadProviderResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new DynamicLoadProviderResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new SSLResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder;
        ResourceTransformationDescriptionBuilder resourceTransformationDescriptionBuilder = builder = ModClusterModel.VERSION_6_0_0.requiresTransformation(version) ? parent.addChildRedirection(WILDCARD_PATH, (PathAddressTransformer)new PathAddressTransformer.BasicPathAddressTransformer(LEGACY_PATH), (DynamicDiscardPolicy)new ProxyConfigurationDynamicDiscardPolicy()) : parent.addChildResource(WILDCARD_PATH);
        if (ModClusterModel.VERSION_6_0_0.requiresTransformation(version)) {
            builder.setCustomResourceTransformer(new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    if (resource.hasChild(SimpleLoadProviderResourceDefinition.PATH)) {
                        ModelNode model = resource.getModel();
                        ModelNode simpleModel = Resource.Tools.readModel((Resource)resource.removeChild(SimpleLoadProviderResourceDefinition.PATH));
                        model.get(DeprecatedAttribute.SIMPLE_LOAD_PROVIDER.getName()).set(simpleModel.get(SimpleLoadProviderResourceDefinition.Attribute.FACTOR.getName()));
                    }
                    context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource).processChildren(resource);
                }
            });
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRename(Attribute.LISTENER.getDefinition(), DeprecatedAttribute.CONNECTOR.getName())).end();
        }
        if (ModClusterModel.VERSION_5_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Attribute.SSL_CONTEXT.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.SSL_CONTEXT.getDefinition()})).end();
        }
        if (ModClusterModel.VERSION_4_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    if (!attributeValue.isDefined()) {
                        attributeValue.set(" ");
                    }
                }
            }, new AttributeDefinition[]{Attribute.EXCLUDED_CONTEXTS.getDefinition()})).end();
        }
        if (ModClusterModel.VERSION_3_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{Attribute.STATUS_INTERVAL.getDefinition().getDefaultValue()}), new AttributeDefinition[]{Attribute.STATUS_INTERVAL.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleAcceptAttributeChecker(Attribute.STATUS_INTERVAL.getDefinition().getDefaultValue()), new AttributeDefinition[]{Attribute.STATUS_INTERVAL.getDefinition()})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Attribute.PROXIES.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.PROXIES.getDefinition()})).end();
        }
        SimpleLoadProviderResourceDefinition.buildTransformation(version, builder);
        DynamicLoadProviderResourceDefinition.buildTransformation(version, builder);
        SSLResourceDefinition.buildTransformation(version, builder);
    }

    private static class ProxyConfigurationDynamicDiscardPolicy
    implements DynamicDiscardPolicy {
        private ProxyConfigurationDynamicDiscardPolicy() {
        }

        public DiscardPolicy checkResource(TransformationContext context, PathAddress address) {
            Resource resource = context.readResourceFromRoot(address.getParent());
            if (resource.hasChildren(WILDCARD_PATH.getKey()) && resource.getChildren(WILDCARD_PATH.getKey()).size() > 1) {
                return DiscardPolicy.REJECT_AND_WARN;
            }
            return DiscardPolicy.NEVER;
        }
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        CONNECTOR("connector", ModelType.STRING, ModClusterModel.VERSION_6_0_0),
        SIMPLE_LOAD_PROVIDER("simple-load-provider", ModelType.INT, ModClusterModel.VERSION_6_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, ModClusterModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setDeprecated(deprecation.getVersion())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        ADVERTISE("advertise", ModelType.BOOLEAN, ModelNode.TRUE),
        ADVERTISE_SECURITY_KEY("advertise-security-key", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_SECURITY_DEF);
            }
        }
        ,
        ADVERTISE_SOCKET("advertise-socket", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference(CommonUnaryRequirement.SOCKET_BINDING.getName());
            }
        }
        ,
        AUTO_ENABLE_CONTEXTS("auto-enable-contexts", ModelType.BOOLEAN, ModelNode.TRUE),
        BALANCER("balancer", ModelType.STRING, null),
        EXCLUDED_CONTEXTS("excluded-contexts", ModelType.STRING, null),
        FLUSH_PACKETS("flush-packets", ModelType.BOOLEAN, ModelNode.FALSE),
        FLUSH_WAIT("flush-wait", ModelType.INT, new ModelNode(-1)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE);
            }
        }
        ,
        LISTENER("listener", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setCapabilityReference(ProxyConfigurationResourceDefinition.UNDERTOW_LISTENER_CAPABILITY_NAME)).setRequired(true);
            }
        }
        ,
        LOAD_BALANCING_GROUP("load-balancing-group", ModelType.STRING, null),
        MAX_ATTEMPTS("max-attempts", ModelType.INT, new ModelNode(1)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setCorrector(new ParameterCorrector(){

                    public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
                        return newValue.getType().equals((Object)ModelType.INT) && newValue.asInt() == -1 ? new ModelNode(1) : newValue;
                    }
                });
            }
        }
        ,
        NODE_TIMEOUT("node-timeout", ModelType.INT, new ModelNode(-1)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE);
            }
        }
        ,
        PING("ping", ModelType.INT, new ModelNode(10)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS);
            }
        }
        ,
        PROXIES("proxies"),
        PROXY_LIST("proxy-list", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setValidator(new ParameterValidator(){

                    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                        if (value.isDefined()) {
                            String[] results;
                            String str = value.asString();
                            for (String result : results = str.split(",")) {
                                int i = result.lastIndexOf(":");
                                try {
                                    if (i > 1 && Integer.parseInt(result.substring(i + 1)) > 0) continue;
                                    throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.needHostAndPort(result));
                                }
                                catch (NumberFormatException e) {
                                    throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.needHostAndPort(result));
                                }
                            }
                        }
                    }
                })).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).setDeprecated(ModClusterModel.VERSION_2_0_0.getVersion())).addAlternatives(new String[]{PROXIES.getName()});
            }
        }
        ,
        PROXY_URL("proxy-url", ModelType.STRING, new ModelNode("/")){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF);
            }
        }
        ,
        SESSION_DRAINING_STRATEGY("session-draining-strategy", ModelType.STRING, new ModelNode(SessionDrainingStrategyEnum.DEFAULT.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(SessionDrainingStrategyEnum.class, (Enum[])SessionDrainingStrategyEnum.values()));
            }
        }
        ,
        SMAX("smax", ModelType.INT, new ModelNode(-1)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE);
            }
        }
        ,
        SOCKET_TIMEOUT("socket-timeout", ModelType.INT, new ModelNode(20)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true));
            }
        }
        ,
        SSL_CONTEXT("ssl-context", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setCapabilityReference(CommonUnaryRequirement.SSL_CONTEXT.getName())).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF});
            }
        }
        ,
        STATUS_INTERVAL("status-interval", ModelType.INT, new ModelNode(10)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true));
            }
        }
        ,
        STICKY_SESSION("sticky-session", ModelType.BOOLEAN, ModelNode.TRUE),
        STICKY_SESSION_REMOVE("sticky-session-remove", ModelType.BOOLEAN, ModelNode.FALSE),
        STICKY_SESSION_FORCE("sticky-session-force", ModelType.BOOLEAN, ModelNode.FALSE),
        STOP_CONTEXT_TIMEOUT("stop-context-timeout", ModelType.INT, new ModelNode(10)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true));
            }
        }
        ,
        TTL("ttl", ModelType.INT, new ModelNode(-1)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE);
            }
        }
        ,
        WORKER_TIMEOUT("worker-timeout", ModelType.INT, new ModelNode(-1)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setRestartAllServices()).build();
        }

        private Attribute(String name) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setRequired(false)).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getName())).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).addAlternatives(new String[]{"proxy-list"})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    public static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        SERVICE("org.wildfly.mod_cluster.service", ModClusterServiceMBean.class);

        private final RuntimeCapability<Void> definition;

        private Capability(String name, Class<?> type) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true, type).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.DEFAULT).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }
    }
}

