/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthStatus {
    public static HealthCheck up(String name) {
        return HealthStatus.state(name, true);
    }

    public static HealthCheck down(String name) {
        return HealthStatus.state(name, false);
    }

    public static HealthCheck state(BooleanSupplier supplier) {
        return HealthStatus.state(supplier.getAsBoolean());
    }

    public static HealthCheck state(boolean state) {
        return HealthStatus.state(HealthStatus.generateRandomHealthCheckName(), state);
    }

    public static HealthCheck state(String name, BooleanSupplier supplier) {
        return HealthStatus.state(name, supplier.getAsBoolean());
    }

    public static HealthCheck state(String name, boolean state) {
        return () -> HealthCheckResponse.named((String)name).state(state).build();
    }

    private static final String generateRandomHealthCheckName() {
        int suffix = ThreadLocalRandom.current().nextInt(99999);
        return String.format("unnamed-health-check-%05d", suffix);
    }
}

