/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.utils;

import java.util.Arrays;
import org.aesh.terminal.tty.Point;
import org.aesh.terminal.utils.InfoCmpHelper;

public class ANSI {
    private static final int TAB = 4;
    public static final String START = "\u001b[";
    public static final String BLACK_TEXT = "\u001b[0;30m";
    public static final String RED_TEXT = "\u001b[0;31m";
    public static final String GREEN_TEXT = "\u001b[0;32m";
    public static final String YELLOW_TEXT = "\u001b[0;33m";
    public static final String BLUE_TEXT = "\u001b[0;34m";
    public static final String MAGENTA_TEXT = "\u001b[0;35m";
    public static final String CYAN_TEXT = "\u001b[0;36m";
    public static final String WHITE_TEXT = "\u001b[0;37m";
    public static final String DEFAULT_TEXT = "\u001b[0;39m";
    public static final String BLACK_BG = "\u001b[0;40m";
    public static final String RED_BG = "\u001b[0;41m";
    public static final String GREEN_BG = "\u001b[0;42m";
    public static final String YELLOW_BG = "\u001b[0;43m";
    public static final String BLUE_BG = "\u001b[0;44m";
    public static final String MAGENTA_BG = "\u001b[0;45m";
    public static final String CYAN_BG = "\u001b[0;46m";
    public static final String WHITE_BG = "\u001b[0;47m";
    public static final String DEFAULT_BG = "\u001b[0;49m";
    public static final String ALTERNATE_BUFFER = InfoCmpHelper.getCurrentTranslatedCapability("smcup", "\u001b[?1049h");
    public static final String MAIN_BUFFER = InfoCmpHelper.getCurrentTranslatedCapability("rmcup", "\u001b[?1049l");
    public static final String INVERT_BACKGROUND = InfoCmpHelper.getCurrentTranslatedCapability("smso", "\u001b[7m");
    public static final String NORMAL_BACKGROUND = InfoCmpHelper.getCurrentTranslatedCapability("rmso", "\u001b[27m");
    public static final String RESET = "\u001b[0m";
    public static final String BOLD = InfoCmpHelper.getCurrentTranslatedCapability("bold", "\u001b[0;1m");
    public static final String BOLD_OFF = "\u001b[0;22m";
    public static final String UNDERLINE = InfoCmpHelper.getCurrentTranslatedCapability("smul", "\u001b[0;4m");
    public static final String UNDERLINE_OFF = InfoCmpHelper.getCurrentTranslatedCapability("rmul", "\u001b[0;24m");
    public static final String BLINK = InfoCmpHelper.getCurrentTranslatedCapability("blink", "\u001b[5m");
    public static final String BLINK_OFF = "\u001b[25m";
    public static final int[] CURSOR_START = new int[]{27, 91, 71};
    public static final int[] ERASE_WHOLE_LINE = new int[]{27, 91, 50, 75};
    public static final String CURSOR_ROW = "\u001b[6n";
    public static final int[] CLEAR_SCREEN = InfoCmpHelper.getCurrentTranslatedCapability("clear", "\u001b[2J").codePoints().toArray();
    public static final String CURSOR_SAVE = InfoCmpHelper.getCurrentTranslatedCapability("sc", "\u001b[s");
    public static final String CURSOR_RESTORE = InfoCmpHelper.getCurrentTranslatedCapability("rc", "\u001b[u");
    public static final String CURSOR_HIDE = "\u001b[?25l";
    public static final String CURSOR_SHOW = "\u001b[?25h";
    public static final int[] ERASE_LINE_FROM_CURSOR = new int[]{27, 91, 75};
    public static final int[] MOVE_LINE_UP = new int[]{27, 91, 49, 65};
    public static final int[] MOVE_LINE_DOWN = new int[]{27, 91, 49, 66};
    public static final String LIGHT_BG = "\u001b[?5h";
    public static final String DARK_BG = "\u001b[?5l";

    private ANSI() {
    }

    public static int[] printAnsi(String out) {
        return ANSI.printAnsi(out.toCharArray());
    }

    public static int[] printAnsi(char ... out) {
        int[] ansi = new int[out.length + 2];
        ansi[0] = 27;
        ansi[1] = 91;
        int counter = 0;
        for (int n : out) {
            if (n == 9) {
                Arrays.fill(ansi, counter + 2, counter + 2 + 4, 32);
                counter += 3;
            } else {
                ansi[counter + 2] = n;
            }
            ++counter;
        }
        return ansi;
    }

    public static Point getActualCursor(int[] input) {
        boolean started = false;
        boolean gotSep = false;
        int col = 0;
        int row = 0;
        for (int i = 0; i < input.length - 1; ++i) {
            if (started) {
                char c;
                if (input[i] == 82) break;
                if (input[i] == 59) {
                    gotSep = true;
                    continue;
                }
                if (gotSep) {
                    c = (char)input[i];
                    col *= 10;
                    col += c & 0xF;
                    continue;
                }
                c = (char)input[i];
                row *= 10;
                row += c & 0xF;
                continue;
            }
            if (input[i] != 27 || i >= input.length - 1 || input[i + 1] != 91) continue;
            started = true;
            ++i;
        }
        return new Point(col, row);
    }
}

