/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.utils.ExecHelper;
import org.aesh.terminal.utils.OSUtils;

public final class InfoCmp {
    private static final Map<String, String> CAPS = new HashMap<String, String>();

    private InfoCmp() {
    }

    public static String getInfoCmp(String terminal) throws IOException, InterruptedException {
        String caps = CAPS.get(terminal);
        if (caps == null) {
            Process p = new ProcessBuilder(OSUtils.INFOCMP_COMMAND, terminal).start();
            caps = ExecHelper.waitAndCapture(p);
            CAPS.put(terminal, caps);
        }
        return caps;
    }

    public static String getDefaultInfoCmp(String terminal) {
        if (terminal.toLowerCase().contains("windows")) {
            return InfoCmp.readDefaultInfoCmp("windows_caps.src");
        }
        if (terminal.toLowerCase().contains("xterm_256color")) {
            return InfoCmp.readDefaultInfoCmp("xterm_256color_caps.src");
        }
        if (terminal.toLowerCase().contains("xterm")) {
            return InfoCmp.readDefaultInfoCmp("xterm_caps.src");
        }
        if (terminal.toLowerCase().contains("vt100")) {
            return InfoCmp.readDefaultInfoCmp("vt100_caps.src");
        }
        return InfoCmp.readDefaultInfoCmp("ansi_caps.src");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readDefaultInfoCmp(String filename) {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        try (InputStream in = InfoCmp.class.getResourceAsStream(filename);){
            byte[] buffer = new byte[256];
            while (true) {
                int len;
                if ((len = in.read(buffer)) == -1) {
                    String string = res.toString("ISO-8859-1");
                    return string;
                }
                res.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setDefaultInfoCmp(String terminal, String caps) {
        CAPS.putIfAbsent(terminal, caps);
    }

    public static void parseInfoCmp(String capabilities, Set<Capability> bools, Map<Capability, Integer> ints, Map<Capability, String> strings) {
        String[] lines = capabilities.split("\n");
        for (int i = 1; i < lines.length; ++i) {
            Matcher m = Pattern.compile("\\s*(([^,]|\\\\,)+)\\s*[,$]").matcher(lines[i]);
            while (m.find()) {
                String val;
                String key;
                String cap = m.group(1);
                if (cap.contains("#")) {
                    int iVal;
                    int index = cap.indexOf(35);
                    key = cap.substring(0, index);
                    val = cap.substring(index + 1);
                    int n = iVal = val.startsWith("0x") ? Integer.parseInt(val.substring(2), 16) : Integer.parseInt(val);
                    Capability c = Capability.byName(key);
                    if (c == null) continue;
                    ints.put(c, iVal);
                    continue;
                }
                if (cap.contains("=")) {
                    int index = cap.indexOf(61);
                    key = cap.substring(0, index);
                    val = cap.substring(index + 1);
                    Capability c = Capability.byName(key);
                    if (c == null) continue;
                    strings.put(c, val);
                    continue;
                }
                Capability c = Capability.byName(cap);
                if (c == null) continue;
                bools.add(c);
            }
        }
    }
}

