/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public final class PostgresSequentialSequentialFileDriver
extends JDBCSequentialFileFactoryDriver {
    private static final String POSTGRES_OID_KEY = "POSTGRES_OID_KEY";

    public PostgresSequentialSequentialFileDriver() throws SQLException {
    }

    public PostgresSequentialSequentialFileDriver(DataSource dataSource, SQLProvider provider) {
        this.setDataSource(dataSource);
        this.setSqlProvider(provider);
    }

    public PostgresSequentialSequentialFileDriver(Connection connection, SQLProvider provider) {
        this.setConnection(connection);
        this.setSqlProvider(provider);
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.deleteFile = this.connection.prepareStatement(this.sqlProvider.getDeleteFileSQL());
        this.createFile = this.connection.prepareStatement(this.sqlProvider.getInsertFileSQL(), 1);
        this.selectFileByFileName = this.connection.prepareStatement(this.sqlProvider.getSelectFileByFileName());
        this.copyFileRecord = this.connection.prepareStatement(this.sqlProvider.getCopyFileRecordByIdSQL());
        this.renameFile = this.connection.prepareStatement(this.sqlProvider.getUpdateFileNameByIdSQL());
        this.readLargeObject = this.connection.prepareStatement(this.sqlProvider.getReadLargeObjectSQL());
        this.appendToLargeObject = this.connection.prepareStatement(this.sqlProvider.getAppendToLargeObjectSQL());
        this.selectFileNamesByExtension = this.connection.prepareStatement(this.sqlProvider.getSelectFileNamesByExtensionSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile(JDBCSequentialFile file) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                LargeObjectManager lobjManager = ((PGConnection)this.connection).getLargeObjectAPI();
                long oid = lobjManager.createLO();
                this.createFile.setString(1, file.getFileName());
                this.createFile.setString(2, file.getExtension());
                this.createFile.setLong(3, oid);
                this.createFile.executeUpdate();
                try (ResultSet keys = this.createFile.getGeneratedKeys();){
                    keys.next();
                    file.setId(keys.getLong(1));
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFile(JDBCSequentialFile file) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            this.connection.setAutoCommit(false);
            this.readLargeObject.setLong(1, file.getId());
            try (ResultSet rs = this.readLargeObject.executeQuery();){
                if (rs.next()) {
                    file.setWritePosition(this.getPostGresLargeObjectSize(file));
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeToFile(JDBCSequentialFile file, byte[] data, boolean append) throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            LargeObjectManager lobjManager = ((PGConnection)this.connection).getLargeObjectAPI();
            LargeObject largeObject = null;
            Long oid = this.getOID(file);
            try {
                this.connection.setAutoCommit(false);
                largeObject = lobjManager.open(oid.longValue(), 131072);
                if (append) {
                    largeObject.seek(largeObject.size());
                } else {
                    largeObject.truncate(0);
                }
                largeObject.write(data);
                largeObject.close();
                this.connection.commit();
            }
            catch (Exception e) {
                this.connection.rollback();
                throw e;
            }
            return data.length;
        }
    }

    @Override
    public int readFromFile(JDBCSequentialFile file, ByteBuffer bytes) throws SQLException {
        LargeObjectManager lobjManager = ((PGConnection)this.connection).getLargeObjectAPI();
        LargeObject largeObject = null;
        long oid = this.getOID(file);
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                largeObject = lobjManager.open(oid, 262144);
                int readLength = (int)this.calculateReadLength(largeObject.size(), bytes.remaining(), file.position());
                if (readLength > 0) {
                    if (file.position() > 0L) {
                        largeObject.seek((int)file.position());
                    }
                    byte[] data = largeObject.read(readLength);
                    bytes.put(data);
                }
                largeObject.close();
                this.connection.commit();
                return readLength;
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getOID(JDBCSequentialFile file) throws SQLException {
        Long oid = (Long)file.getMetaData(POSTGRES_OID_KEY);
        if (oid == null) {
            Connection connection = this.connection;
            synchronized (connection) {
                this.connection.setAutoCommit(false);
                this.readLargeObject.setLong(1, file.getId());
                try (ResultSet rs = this.readLargeObject.executeQuery();){
                    if (rs.next()) {
                        file.addMetaData(POSTGRES_OID_KEY, rs.getLong(1));
                    }
                    this.connection.commit();
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    throw e;
                }
            }
        }
        if ((Long)file.getMetaData(POSTGRES_OID_KEY) == 0L) {
            System.out.println("FD");
        }
        return (Long)file.getMetaData(POSTGRES_OID_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPostGresLargeObjectSize(JDBCSequentialFile file) throws SQLException {
        LargeObjectManager lobjManager = ((PGConnection)this.connection).getLargeObjectAPI();
        int size = 0;
        Long oid = this.getOID(file);
        if (oid != null) {
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    this.connection.setAutoCommit(false);
                    LargeObject largeObject = lobjManager.open(oid.longValue(), 262144);
                    size = largeObject.size();
                    largeObject.close();
                    this.connection.commit();
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    throw e;
                }
            }
        }
        return size;
    }
}

