/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsBytesMessage;
import org.jboss.resource.adapter.jms.JmsMapMessage;
import org.jboss.resource.adapter.jms.JmsMessage;
import org.jboss.resource.adapter.jms.JmsMessageListener;
import org.jboss.resource.adapter.jms.JmsObjectMessage;
import org.jboss.resource.adapter.jms.JmsSession;
import org.jboss.resource.adapter.jms.JmsStreamMessage;
import org.jboss.resource.adapter.jms.JmsTextMessage;

public class JmsMessageConsumer
implements MessageConsumer {
    private static final Logger log = Logger.getLogger(JmsMessageConsumer.class);
    MessageConsumer consumer;
    JmsSession session;
    private boolean trace = log.isTraceEnabled();

    public JmsMessageConsumer(MessageConsumer consumer, JmsSession session) {
        this.consumer = consumer;
        this.session = session;
        if (this.trace) {
            log.trace((Object)("new JmsMessageConsumer " + this + " consumer=" + consumer + " session=" + session));
        }
    }

    public void close() throws JMSException {
        if (this.trace) {
            log.trace((Object)("close " + this));
        }
        try {
            this.closeConsumer();
        }
        finally {
            this.session.removeConsumer(this);
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.session.checkStrict();
        return this.consumer.getMessageListener();
    }

    public String getMessageSelector() throws JMSException {
        return this.consumer.getMessageSelector();
    }

    public Message receive() throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("receive " + this));
            }
            Message message = this.consumer.receive();
            if (this.trace) {
                log.trace((Object)("received " + this + " result=" + message));
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("receive " + this + " timeout=" + timeout));
            }
            Message message = this.consumer.receive(timeout);
            if (this.trace) {
                log.trace((Object)("received " + this + " result=" + message));
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    public Message receiveNoWait() throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("receiveNoWait " + this));
            }
            Message message = this.consumer.receiveNoWait();
            if (this.trace) {
                log.trace((Object)("received " + this + " result=" + message));
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.lock();
        try {
            this.session.checkStrict();
            if (listener == null) {
                this.consumer.setMessageListener(null);
            } else {
                this.consumer.setMessageListener(this.wrapMessageListener(listener));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    void closeConsumer() throws JMSException {
        this.consumer.close();
    }

    Message wrapMessage(Message message) {
        if (message instanceof BytesMessage) {
            return new JmsBytesMessage((BytesMessage)message, this.session);
        }
        if (message instanceof MapMessage) {
            return new JmsMapMessage((MapMessage)message, this.session);
        }
        if (message instanceof ObjectMessage) {
            return new JmsObjectMessage((ObjectMessage)message, this.session);
        }
        if (message instanceof StreamMessage) {
            return new JmsStreamMessage((StreamMessage)message, this.session);
        }
        if (message instanceof TextMessage) {
            return new JmsTextMessage((TextMessage)message, this.session);
        }
        return new JmsMessage(message, this.session);
    }

    MessageListener wrapMessageListener(MessageListener listener) {
        return new JmsMessageListener(listener, this);
    }
}

