/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.AnyServerEquivalence;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

public final class EquivalenceExternalizer
extends AbstractExternalizer<Equivalence> {
    private static final int BYTE_ARRAY_EQ = 0;
    private static final int ANY_EQ = 1;
    private static final int ANY_SERVER_EQ = 2;
    private final IdentityIntMap<Class<?>> subIds = new IdentityIntMap(4);

    public EquivalenceExternalizer() {
        this.subIds.put(ByteArrayEquivalence.class, 0);
        this.subIds.put(AnyEquivalence.class, 1);
        this.subIds.put(AnyServerEquivalence.class, 2);
    }

    @Override
    public Set<Class<? extends Equivalence>> getTypeClasses() {
        return Util.asSet(ByteArrayEquivalence.class, AnyEquivalence.class, AnyServerEquivalence.class);
    }

    @Override
    public Integer getId() {
        return 83;
    }

    @Override
    public void writeObject(ObjectOutput out, Equivalence obj) throws IOException {
        int subId = this.subIds.get(obj.getClass(), -1);
        out.writeByte(subId);
    }

    @Override
    public Equivalence readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int subId = input.readUnsignedByte();
        switch (subId) {
            case 0: {
                return ByteArrayEquivalence.INSTANCE;
            }
            case 1: {
                return AnyEquivalence.getInstance();
            }
            case 2: {
                return AnyServerEquivalence.INSTANCE;
            }
        }
        throw new IllegalStateException("Unknown equivalence type: " + Integer.toHexString(subId));
    }
}

