/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.Properties;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;

public final class BackendFactory {
    private BackendFactory() {
    }

    public static BackendQueueProcessor createBackend(IndexManager indexManager, WorkerBuildContext buildContext, Properties properties) {
        IndexManagerGroupHolder groupHolder = BackendFactory.getGroupHolder(indexManager, buildContext);
        Backend backend = groupHolder.getOrCreateBackend(indexManager.getIndexName(), properties, buildContext);
        return backend.createQueueProcessor(indexManager, buildContext);
    }

    public static BackendQueueProcessor createBackend(String backendName, IndexManager indexManager, WorkerBuildContext buildContext, Properties properties) {
        IndexManagerGroupHolder groupHolder = BackendFactory.getGroupHolder(indexManager, buildContext);
        Backend backend = groupHolder.getOrCreateBackend(backendName, indexManager.getIndexName(), properties, buildContext);
        return backend.createQueueProcessor(indexManager, buildContext);
    }

    private static IndexManagerGroupHolder getGroupHolder(IndexManager indexManager, WorkerBuildContext buildContext) {
        IndexManagerHolder indexManagerHolder = buildContext.getAllIndexesManager();
        return indexManagerHolder.getGroupHolderByIndexManager(indexManager);
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("worker.execution"));
    }
}

