/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.util.List;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.tom.DeliveryManager;
import org.jgroups.protocols.tom.DeliveryProtocol;

public class DeliveryThread
extends Thread {
    private DeliveryManager deliveryManager;
    private volatile boolean running = false;
    private final DeliveryProtocol deliveryProtocol;
    private final Log log = LogFactory.getLog(this.getClass());

    public DeliveryThread(DeliveryProtocol protocol) {
        super("TOA-Delivery-Thread");
        if (protocol == null) {
            throw new NullPointerException("TOA Protocol can't be null");
        }
        this.deliveryProtocol = protocol;
    }

    public void start(DeliveryManager deliveryManager) {
        this.deliveryManager = deliveryManager;
        this.start();
    }

    public void setLocalAddress(String localAddress) {
        this.setName("TOA-Delivery-Thread-" + localAddress);
    }

    @Override
    public void start() {
        if (this.deliveryManager == null) {
            throw new NullPointerException("Delivery Manager can't be null");
        }
        this.running = true;
        super.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                List<Message> messages = this.deliveryManager.getNextMessagesToDeliver();
                for (Message msg : messages) {
                    try {
                        this.deliveryProtocol.deliver(msg);
                    }
                    catch (Throwable t) {
                        this.log.warn("Exception caught while delivering message " + msg, t);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void interrupt() {
        this.running = false;
        super.interrupt();
    }
}

